/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Artemis {
    public static void main(String[] args) throws Throwable {
        String home = System.getProperty("artemis.home");
        File fileHome = home != null ? new File(home) : null;
        String instance = System.getProperty("artemis.instance");
        File fileInstance = instance != null ? new File(instance) : null;
        Artemis.execute(fileHome, fileInstance, args);
    }

    public static Object execute(File artemisHome, File artemisInstance, List<String> args) throws Throwable {
        return Artemis.execute(artemisHome, artemisInstance, args.toArray(new String[args.size()]));
    }

    public static Object execute(File fileHome, File fileInstance, String ... args) throws Throwable {
        String loggingConfig;
        Object etcFile;
        ArrayList<File> dirs = new ArrayList<File>();
        if (fileHome != null) {
            dirs.add(new File(fileHome, "lib"));
        }
        if (fileInstance != null) {
            dirs.add(new File(fileInstance, "lib"));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (fileInstance != null) {
            etcFile = new File(fileInstance, "etc");
            urls.add(((File)etcFile).toURI().toURL());
        }
        if (fileHome != null) {
            etcFile = new File(fileHome, "etc");
            urls.add(((File)etcFile).toURI().toURL());
        }
        for (File bootdir : dirs) {
            if (!bootdir.exists() || !bootdir.isDirectory()) continue;
            ArrayList<File> files = new ArrayList<File>();
            for (File f : bootdir.listFiles()) {
                if (!f.getName().endsWith(".jar") && !f.getName().endsWith(".zip")) continue;
                files.add(f);
            }
            Collections.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file, File file1) {
                    return file.getName().compareTo(file1.getName());
                }
            });
            for (File f : files) {
                Artemis.add(urls, f);
            }
        }
        if (fileInstance != null) {
            System.setProperty("java.io.tmpdir", new File(fileInstance, "tmp").getCanonicalPath());
        }
        if ((loggingConfig = System.getProperty("logging.configuration")) != null) {
            System.setProperty("logging.configuration", Artemis.fixupFileURI(loggingConfig));
        }
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> clazz = loader.loadClass("org.apache.activemq.artemis.cli.Artemis");
        Method method = clazz.getMethod("execute", File.class, File.class, args.getClass());
        try {
            Object object = method.invoke(null, fileHome, fileInstance, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    static String fixupFileURI(String value) {
        if (value != null && value.startsWith("file:")) {
            value = value.substring("file:".length());
            value = new File(value).toURI().toString();
        }
        return value;
    }

    private static void add(ArrayList<URL> urls, File file) {
        try {
            urls.add(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

