/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.activemq.artemis.jdbc.store.drivers.derby.DerbySQLProvider;
import org.apache.activemq.artemis.jdbc.store.drivers.mysql.MySQLSQLProvider;
import org.apache.activemq.artemis.jdbc.store.drivers.postgres.PostgresSQLProvider;
import org.apache.activemq.artemis.jdbc.store.drivers.postgres.PostgresSequentialSequentialFileDriver;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.sql.GenericSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.jboss.logging.Logger;

public class JDBCUtils {
    private static final Logger logger = Logger.getLogger(JDBCUtils.class);

    public static Driver getDriver(String className) throws Exception {
        try {
            Driver driver = (Driver)Class.forName(className).newInstance();
            if (className.equals("org.apache.derby.jdbc.EmbeddedDriver")) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            DriverManager.getConnection("jdbc:derby:;shutdown=true");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            return driver;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class: " + className);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate driver class: ", e);
        }
    }

    public static void createTableIfNotExists(Connection connection, String tableName, String sql) throws SQLException {
        logger.tracef("Validating if table %s didn't exist before creating", (Object)tableName);
        try {
            connection.setAutoCommit(false);
            try (ResultSet rs = connection.getMetaData().getTables(null, null, tableName, null);){
                if (rs != null && !rs.next()) {
                    logger.tracef("Table %s did not exist, creating it with SQL=%s", (Object)tableName, (Object)sql);
                    Statement statement = connection.createStatement();
                    statement.executeUpdate(sql);
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            connection.rollback();
        }
    }

    public static SQLProvider getSQLProvider(String driverClass, String tableName) {
        if (driverClass.contains("derby")) {
            logger.tracef("getSQLProvider Returning Derby SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            return new DerbySQLProvider(tableName);
        }
        if (driverClass.contains("postgres")) {
            logger.tracef("getSQLProvider Returning postgres SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            return new PostgresSQLProvider(tableName);
        }
        if (driverClass.contains("mysql")) {
            logger.tracef("getSQLProvider Returning mysql SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            return new MySQLSQLProvider(tableName);
        }
        logger.tracef("getSQLProvider Returning generic SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
        return new GenericSQLProvider(tableName);
    }

    public static JDBCSequentialFileFactoryDriver getDBFileDriver(String driverClass, String tableName, String jdbcConnectionUrl) throws SQLException {
        JDBCSequentialFileFactoryDriver dbDriver;
        if (driverClass.contains("derby")) {
            logger.tracef("getDBFileDriver Returning Derby SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            dbDriver = new JDBCSequentialFileFactoryDriver();
            dbDriver.setSqlProvider(new DerbySQLProvider(tableName));
            dbDriver.setJdbcConnectionUrl(jdbcConnectionUrl);
            dbDriver.setJdbcDriverClass(driverClass);
        } else if (driverClass.contains("postgres")) {
            logger.tracef("getDBFileDriver Returning postgres SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            dbDriver = new PostgresSequentialSequentialFileDriver();
            dbDriver.setSqlProvider(new PostgresSQLProvider(tableName));
            dbDriver.setJdbcConnectionUrl(jdbcConnectionUrl);
            dbDriver.setJdbcDriverClass(driverClass);
        } else if (driverClass.contains("mysql")) {
            logger.tracef("getDBFileDriver Returning mysql SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            dbDriver = new JDBCSequentialFileFactoryDriver();
            dbDriver.setSqlProvider(new MySQLSQLProvider(tableName));
            dbDriver.setJdbcConnectionUrl(jdbcConnectionUrl);
            dbDriver.setJdbcDriverClass(driverClass);
        } else {
            logger.tracef("getDBFileDriver generic mysql SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            dbDriver = new JDBCSequentialFileFactoryDriver();
            dbDriver.setSqlProvider(new GenericSQLProvider(tableName));
            dbDriver.setJdbcConnectionUrl(jdbcConnectionUrl);
            dbDriver.setJdbcDriverClass(driverClass);
        }
        return dbDriver;
    }
}

