/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schema.serverLocator;

import java.io.NotSerializableException;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JGroupsPropertiesBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.uri.schema.serverLocator.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.ConnectionOptions;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class JGroupsServerLocatorSchema
extends AbstractServerLocatorSchema {
    public String getSchemaName() {
        return "jgroups";
    }

    protected ServerLocator internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        ConnectionOptions options = this.newConnectionOptions(uri, query);
        DiscoveryGroupConfiguration dcConfig = JGroupsServerLocatorSchema.getDiscoveryGroupConfiguration(uri, query, name);
        if (options.isHa()) {
            return ActiveMQClient.createServerLocatorWithHA(dcConfig);
        }
        return ActiveMQClient.createServerLocatorWithoutHA(dcConfig);
    }

    protected URI internalNewURI(ServerLocator bean) throws Exception {
        String auth;
        DiscoveryGroupConfiguration dgc = bean.getDiscoveryGroupConfiguration();
        BroadcastEndpointFactory endpoint = dgc.getBroadcastEndpointFactory();
        if (endpoint instanceof JGroupsFileBroadcastEndpointFactory) {
            auth = ((JGroupsFileBroadcastEndpointFactory)endpoint).getChannelName();
        } else if (endpoint instanceof JGroupsPropertiesBroadcastEndpointFactory) {
            auth = ((JGroupsPropertiesBroadcastEndpointFactory)endpoint).getChannelName();
        } else {
            throw new NotSerializableException(endpoint + "not serializable");
        }
        String query = BeanSupport.getData(null, (Object[])new Object[]{bean, dgc, endpoint});
        dgc.setBroadcastEndpointFactory(endpoint);
        return new URI("jgroups", null, auth, -1, null, query, null);
    }

    public static DiscoveryGroupConfiguration getDiscoveryGroupConfiguration(URI uri, Map<String, String> query, String name) throws Exception {
        BroadcastEndpointFactory endpointFactory = query.containsKey("file") ? new JGroupsFileBroadcastEndpointFactory().setChannelName(uri.getAuthority()) : new JGroupsPropertiesBroadcastEndpointFactory().setChannelName(uri.getAuthority());
        BeanSupport.setData((URI)uri, (Object)endpointFactory, query);
        DiscoveryGroupConfiguration dcConfig = new DiscoveryGroupConfiguration().setName(name).setBroadcastEndpointFactory(endpointFactory);
        BeanSupport.setData((URI)uri, (Object)dcConfig, query);
        return dcConfig;
    }
}

