/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;

public class ActiveMQChannelHandler
extends ChannelDuplexHandler {
    private final ChannelGroup group;
    private final BufferHandler handler;
    private final BaseConnectionLifeCycleListener listener;
    volatile boolean active;

    protected ActiveMQChannelHandler(ChannelGroup group, BufferHandler handler, BaseConnectionLifeCycleListener listener) {
        this.group = group;
        this.handler = handler;
        this.listener = listener;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.group.add((Object)ctx.channel());
        ctx.fireChannelActive();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.listener.connectionReadyForWrites(ActiveMQChannelHandler.channelId(ctx.channel()), ctx.channel().isWritable());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg;
        this.handler.bufferReceived(ActiveMQChannelHandler.channelId(ctx.channel()), (ActiveMQBuffer)new ChannelBufferWrapper(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ActiveMQChannelHandler activeMQChannelHandler = this;
        synchronized (activeMQChannelHandler) {
            if (this.active) {
                this.listener.connectionDestroyed(ActiveMQChannelHandler.channelId(ctx.channel()));
                this.active = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.active) {
            return;
        }
        ActiveMQInternalErrorException me = ActiveMQClientMessageBundle.BUNDLE.nettyError();
        me.initCause(cause);
        BaseConnectionLifeCycleListener baseConnectionLifeCycleListener = this.listener;
        synchronized (baseConnectionLifeCycleListener) {
            try {
                this.listener.connectionException(ActiveMQChannelHandler.channelId(ctx.channel()), (ActiveMQException)me);
                this.active = false;
            }
            catch (Exception ex) {
                ActiveMQClientLogger.LOGGER.errorCallingLifeCycleListener(ex);
            }
        }
    }

    protected static int channelId(Channel channel) {
        return channel.hashCode();
    }
}

