/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.message.impl;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.buffers.impl.ResetLimitWrappedActiveMQBuffer;
import org.apache.activemq.artemis.core.message.BodyEncoder;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.TypedProperties;
import org.apache.activemq.artemis.utils.UUID;

public abstract class MessageImpl
implements MessageInternal {
    public static final SimpleString HDR_ROUTE_TO_IDS = new SimpleString("_AMQ_ROUTE_TO");
    public static final SimpleString HDR_SCALEDOWN_TO_IDS = new SimpleString("_AMQ_SCALEDOWN_TO");
    public static final SimpleString HDR_ROUTE_TO_ACK_IDS = new SimpleString("_AMQ_ACK_ROUTE_TO");
    public static final SimpleString HDR_BRIDGE_DUPLICATE_ID = new SimpleString("_AMQ_BRIDGE_DUP");
    public static final int BUFFER_HEADER_SPACE = 13;
    public static final int BODY_OFFSET = 17;
    protected long messageID;
    protected SimpleString address;
    protected byte type;
    protected boolean durable;
    private long expiration;
    protected long timestamp;
    protected TypedProperties properties;
    protected byte priority;
    protected ActiveMQBuffer buffer;
    protected ResetLimitWrappedActiveMQBuffer bodyBuffer;
    protected volatile boolean bufferValid;
    private int endOfBodyPosition = -1;
    private int endOfMessagePosition;
    private UUID userID;

    protected MessageImpl() {
        this.properties = new TypedProperties();
    }

    protected MessageImpl(byte type, boolean durable, long expiration, long timestamp, byte priority, int initialMessageBufferSize) {
        this();
        this.type = type;
        this.durable = durable;
        this.expiration = expiration;
        this.timestamp = timestamp;
        this.priority = priority;
        this.createBody(initialMessageBufferSize);
    }

    protected MessageImpl(int initialMessageBufferSize) {
        this();
        this.createBody(initialMessageBufferSize);
    }

    protected MessageImpl(MessageImpl other) {
        this(other, other.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageImpl(MessageImpl other, TypedProperties properties) {
        this.messageID = other.getMessageID();
        this.userID = other.getUserID();
        this.address = other.getAddress();
        this.type = other.getType();
        this.durable = other.isDurable();
        this.expiration = other.getExpiration();
        this.timestamp = other.getTimestamp();
        this.priority = other.getPriority();
        this.properties = new TypedProperties(properties);
        MessageImpl messageImpl = other;
        synchronized (messageImpl) {
            this.bufferValid = false;
            this.endOfBodyPosition = -1;
            this.endOfMessagePosition = other.endOfMessagePosition;
            if (other.buffer != null) {
                this.buffer = other.buffer.copy(0, other.buffer.capacity());
                this.buffer.setIndex(other.buffer.readerIndex(), this.buffer.capacity());
                this.bodyBuffer = new ResetLimitWrappedActiveMQBuffer(17, this.buffer, (MessageInternal)this);
                this.bodyBuffer.readerIndex(17);
                this.bodyBuffer.writerIndex(other.getBodyBuffer().writerIndex());
            }
        }
    }

    @Override
    public int getEncodeSize() {
        int headersPropsSize = this.getHeadersAndPropertiesEncodeSize();
        int bodyPos = this.getEndOfBodyPosition();
        int bodySize = bodyPos - 13 - 4;
        return 4 + bodySize + 4 + headersPropsSize;
    }

    @Override
    public int getHeadersAndPropertiesEncodeSize() {
        return 9 + (this.userID == null ? 0 : 16) + SimpleString.sizeofNullableString((SimpleString)this.address) + 1 + 1 + 8 + 8 + 1 + this.properties.getEncodeSize();
    }

    @Override
    public void encodeHeadersAndProperties(ActiveMQBuffer buffer) {
        buffer.writeLong(this.messageID);
        buffer.writeNullableSimpleString(this.address);
        if (this.userID == null) {
            buffer.writeByte((byte)0);
        } else {
            buffer.writeByte((byte)1);
            buffer.writeBytes(this.userID.asBytes());
        }
        buffer.writeByte(this.type);
        buffer.writeBoolean(this.durable);
        buffer.writeLong(this.expiration);
        buffer.writeLong(this.timestamp);
        buffer.writeByte(this.priority);
        this.properties.encode(buffer);
    }

    @Override
    public void decodeHeadersAndProperties(ActiveMQBuffer buffer) {
        this.messageID = buffer.readLong();
        this.address = buffer.readNullableSimpleString();
        if (buffer.readByte() == 1) {
            byte[] bytes = new byte[16];
            buffer.readBytes(bytes);
            this.userID = new UUID(1, bytes);
        } else {
            this.userID = null;
        }
        this.type = buffer.readByte();
        this.durable = buffer.readBoolean();
        this.expiration = buffer.readLong();
        this.timestamp = buffer.readLong();
        this.priority = buffer.readByte();
        this.properties.decode(buffer);
    }

    public void copyHeadersAndProperties(MessageInternal msg) {
        this.messageID = msg.getMessageID();
        this.address = msg.getAddress();
        this.userID = msg.getUserID();
        this.type = msg.getType();
        this.durable = msg.isDurable();
        this.expiration = msg.getExpiration();
        this.timestamp = msg.getTimestamp();
        this.priority = msg.getPriority();
        this.properties = msg.getTypedProperties();
    }

    @Override
    public ActiveMQBuffer getBodyBuffer() {
        if (this.bodyBuffer == null) {
            this.bodyBuffer = new ResetLimitWrappedActiveMQBuffer(17, this.buffer, (MessageInternal)this);
        }
        return this.bodyBuffer;
    }

    @Override
    public Message writeBodyBufferBytes(byte[] bytes) {
        this.getBodyBuffer().writeBytes(bytes);
        return this;
    }

    @Override
    public Message writeBodyBufferString(String string) {
        this.getBodyBuffer().writeString(string);
        return this;
    }

    public void checkCompletion() throws ActiveMQException {
    }

    @Override
    public synchronized ActiveMQBuffer getBodyBufferDuplicate() {
        ByteBuf byteBuf = ChannelBufferWrapper.unwrap((ByteBuf)this.getBodyBuffer().byteBuf());
        byteBuf = byteBuf.duplicate();
        byteBuf.readerIndex(this.getBodyBuffer().readerIndex());
        byteBuf.writerIndex(this.getBodyBuffer().writerIndex());
        return new ResetLimitWrappedActiveMQBuffer(17, byteBuf, null);
    }

    @Override
    public long getMessageID() {
        return this.messageID;
    }

    @Override
    public UUID getUserID() {
        return this.userID;
    }

    @Override
    public MessageImpl setUserID(UUID userID) {
        this.userID = userID;
        return this;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message setAddress(SimpleString address) {
        MessageImpl messageImpl = this;
        synchronized (messageImpl) {
            if (this.address != address) {
                this.address = address;
                this.bufferValid = false;
            }
        }
        return this;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public MessageImpl setDurable(boolean durable) {
        if (this.durable != durable) {
            this.durable = durable;
            this.bufferValid = false;
        }
        return this;
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public MessageImpl setExpiration(long expiration) {
        if (this.expiration != expiration) {
            this.expiration = expiration;
            this.bufferValid = false;
        }
        return this;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public MessageImpl setTimestamp(long timestamp) {
        if (this.timestamp != timestamp) {
            this.timestamp = timestamp;
            this.bufferValid = false;
        }
        return this;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public MessageImpl setPriority(byte priority) {
        if (this.priority != priority) {
            this.priority = priority;
            this.bufferValid = false;
        }
        return this;
    }

    @Override
    public boolean isExpired() {
        if (this.expiration == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.expiration >= 0L;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageID", this.messageID);
        if (this.userID != null) {
            map.put("userID", "ID:" + this.userID.toString());
        }
        map.put("address", this.address.toString());
        map.put("type", this.type);
        map.put("durable", this.durable);
        map.put("expiration", this.expiration);
        map.put("timestamp", this.timestamp);
        map.put("priority", this.priority);
        map.putAll(this.toPropertyMap());
        return map;
    }

    @Override
    public Map<String, Object> toPropertyMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (SimpleString propName : this.properties.getPropertyNames()) {
            map.put(propName.toString(), this.properties.getProperty(propName));
        }
        return map;
    }

    @Override
    public void decodeFromBuffer(ActiveMQBuffer buffer) {
        this.buffer = buffer;
        this.decode();
        ResetLimitWrappedActiveMQBuffer tmpbodyBuffer = new ResetLimitWrappedActiveMQBuffer(17, buffer, null);
        tmpbodyBuffer.readerIndex(17);
        tmpbodyBuffer.writerIndex(this.endOfBodyPosition);
        tmpbodyBuffer.setMessage(this);
        this.bodyBuffer = tmpbodyBuffer;
    }

    @Override
    public void bodyChanged() {
        this.bufferValid = false;
        this.endOfBodyPosition = -1;
    }

    @Override
    public int getEndOfMessagePosition() {
        return this.endOfMessagePosition;
    }

    @Override
    public int getEndOfBodyPosition() {
        if (this.endOfBodyPosition < 0) {
            this.endOfBodyPosition = this.getBodyBuffer().writerIndex();
        }
        return this.endOfBodyPosition;
    }

    public void encode(ActiveMQBuffer buff) {
        this.encodeToBuffer();
        buff.writeBytes(this.buffer, 13, this.endOfMessagePosition - 13);
    }

    public void decode(ActiveMQBuffer buff) {
        int start = buff.readerIndex();
        this.endOfBodyPosition = buff.readInt();
        this.endOfMessagePosition = buff.getInt(this.endOfBodyPosition - 13 + start);
        int length = this.endOfMessagePosition - 13;
        this.buffer.setIndex(0, 13);
        this.buffer.writeBytes(buff, start, length);
        this.decode();
        buff.readerIndex(start + length);
    }

    @Override
    public synchronized ActiveMQBuffer getEncodedBuffer() {
        ActiveMQBuffer buff = this.encodeToBuffer();
        return buff.duplicate();
    }

    @Override
    public void setAddressTransient(SimpleString address) {
        this.address = address;
    }

    @Override
    public Message putBooleanProperty(SimpleString key, boolean value) {
        this.properties.putBooleanProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putByteProperty(SimpleString key, byte value) {
        this.properties.putByteProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putBytesProperty(SimpleString key, byte[] value) {
        this.properties.putBytesProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putCharProperty(SimpleString key, char value) {
        this.properties.putCharProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putCharProperty(String key, char value) {
        this.properties.putCharProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putShortProperty(SimpleString key, short value) {
        this.properties.putShortProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putIntProperty(SimpleString key, int value) {
        this.properties.putIntProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putLongProperty(SimpleString key, long value) {
        this.properties.putLongProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putFloatProperty(SimpleString key, float value) {
        this.properties.putFloatProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putDoubleProperty(SimpleString key, double value) {
        this.properties.putDoubleProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putStringProperty(SimpleString key, SimpleString value) {
        this.properties.putSimpleStringProperty(key, value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        TypedProperties.setObjectProperty((SimpleString)key, (Object)value, (TypedProperties)this.properties);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        this.putObjectProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putBooleanProperty(String key, boolean value) {
        this.properties.putBooleanProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putByteProperty(String key, byte value) {
        this.properties.putByteProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putBytesProperty(String key, byte[] value) {
        this.properties.putBytesProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putShortProperty(String key, short value) {
        this.properties.putShortProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putIntProperty(String key, int value) {
        this.properties.putIntProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putLongProperty(String key, long value) {
        this.properties.putLongProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putFloatProperty(String key, float value) {
        this.properties.putFloatProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putDoubleProperty(String key, double value) {
        this.properties.putDoubleProperty(new SimpleString(key), value);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Message putStringProperty(String key, String value) {
        this.properties.putSimpleStringProperty(new SimpleString(key), SimpleString.toSimpleString((String)value));
        this.bufferValid = false;
        return this;
    }

    public Message putTypedProperties(TypedProperties otherProps) {
        this.properties.putTypedProperties(otherProps);
        this.bufferValid = false;
        return this;
    }

    @Override
    public Object getObjectProperty(SimpleString key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.properties.getBooleanProperty(key);
    }

    @Override
    public Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
        return this.properties.getBooleanProperty(new SimpleString(key));
    }

    @Override
    public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.properties.getByteProperty(key);
    }

    @Override
    public Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
        return this.properties.getByteProperty(new SimpleString(key));
    }

    @Override
    public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.properties.getBytesProperty(key);
    }

    @Override
    public byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(new SimpleString(key));
    }

    @Override
    public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.properties.getDoubleProperty(key);
    }

    @Override
    public Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
        return this.properties.getDoubleProperty(new SimpleString(key));
    }

    @Override
    public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.properties.getIntProperty(key);
    }

    @Override
    public Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
        return this.properties.getIntProperty(new SimpleString(key));
    }

    @Override
    public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.properties.getLongProperty(key);
    }

    @Override
    public Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
        return this.properties.getLongProperty(new SimpleString(key));
    }

    @Override
    public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.properties.getShortProperty(key);
    }

    @Override
    public Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
        return this.properties.getShortProperty(new SimpleString(key));
    }

    @Override
    public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.properties.getFloatProperty(key);
    }

    @Override
    public Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
        return this.properties.getFloatProperty(new SimpleString(key));
    }

    @Override
    public String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        SimpleString str = this.getSimpleStringProperty(key);
        if (str == null) {
            return null;
        }
        return str.toString();
    }

    @Override
    public String getStringProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getStringProperty(new SimpleString(key));
    }

    @Override
    public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.properties.getSimpleStringProperty(key);
    }

    @Override
    public SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
        return this.properties.getSimpleStringProperty(new SimpleString(key));
    }

    @Override
    public Object getObjectProperty(String key) {
        return this.properties.getProperty(new SimpleString(key));
    }

    @Override
    public Object removeProperty(SimpleString key) {
        this.bufferValid = false;
        return this.properties.removeProperty(key);
    }

    @Override
    public Object removeProperty(String key) {
        this.bufferValid = false;
        return this.properties.removeProperty(new SimpleString(key));
    }

    @Override
    public boolean containsProperty(SimpleString key) {
        return this.properties.containsProperty(key);
    }

    @Override
    public boolean containsProperty(String key) {
        return this.properties.containsProperty(new SimpleString(key));
    }

    @Override
    public Set<SimpleString> getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    @Override
    public ActiveMQBuffer getWholeBuffer() {
        return this.buffer;
    }

    @Override
    public BodyEncoder getBodyEncoder() throws ActiveMQException {
        return new DecodingContext();
    }

    @Override
    public TypedProperties getTypedProperties() {
        return this.properties;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MessageImpl) {
            MessageImpl message = (MessageImpl)other;
            if (this.getMessageID() == message.getMessageID()) {
                return true;
            }
        }
        return false;
    }

    public String bodyToString() {
        this.getEndOfBodyPosition();
        int readerIndex1 = this.buffer.readerIndex();
        this.buffer.readerIndex(0);
        byte[] buffer1 = new byte[this.buffer.writerIndex()];
        this.buffer.readBytes(buffer1);
        this.buffer.readerIndex(readerIndex1);
        byte[] buffer2 = null;
        if (this.bodyBuffer != null) {
            int readerIndex2 = this.bodyBuffer.readerIndex();
            this.bodyBuffer.readerIndex(0);
            buffer2 = new byte[this.bodyBuffer.writerIndex() - this.bodyBuffer.readerIndex()];
            this.bodyBuffer.readBytes(buffer2);
            this.bodyBuffer.readerIndex(readerIndex2);
            return "ServerMessage@" + Integer.toHexString(System.identityHashCode(this)) + "[writerIndex=" + this.buffer.writerIndex() + ",capacity=" + this.buffer.capacity() + ",bodyStart=" + this.getEndOfBodyPosition() + " buffer=" + ByteUtil.bytesToHex((byte[])buffer1, (int)1) + ", bodyBuffer=" + ByteUtil.bytesToHex((byte[])buffer2, (int)1);
        }
        return "ServerMessage@" + Integer.toHexString(System.identityHashCode(this)) + "[writerIndex=" + this.buffer.writerIndex() + ",capacity=" + this.buffer.capacity() + ",bodyStart=" + this.getEndOfBodyPosition() + " buffer=" + ByteUtil.bytesToHex((byte[])buffer1, (int)1);
    }

    public int hashCode() {
        return 31 + (int)(this.messageID ^ this.messageID >>> 32);
    }

    public TypedProperties getProperties() {
        return this.properties;
    }

    private synchronized ActiveMQBuffer encodeToBuffer() {
        if (!this.bufferValid) {
            int bodySize = this.getEndOfBodyPosition();
            this.buffer.setInt(13, bodySize);
            if (bodySize + 4 > this.buffer.capacity()) {
                this.buffer.setIndex(0, bodySize);
                this.buffer.writeInt(0);
            } else {
                this.buffer.setIndex(0, bodySize + 4);
            }
            this.encodeHeadersAndProperties(this.buffer);
            this.endOfMessagePosition = this.buffer.writerIndex();
            this.buffer.setInt(bodySize, this.endOfMessagePosition);
            this.bufferValid = true;
        }
        return this.buffer;
    }

    private void decode() {
        this.endOfBodyPosition = this.buffer.getInt(13);
        this.buffer.readerIndex(this.endOfBodyPosition + 4);
        this.decodeHeadersAndProperties(this.buffer);
        this.endOfMessagePosition = this.buffer.readerIndex();
        this.bufferValid = true;
    }

    public void createBody(int initialMessageBufferSize) {
        this.buffer = ActiveMQBuffers.dynamicBuffer((int)initialMessageBufferSize);
        this.buffer.writeByte((byte)0);
        this.buffer.setIndex(17, 17);
    }

    private void forceCopy() {
        this.buffer = this.buffer.copy(0, this.buffer.capacity());
        this.buffer.setIndex(0, this.getEndOfBodyPosition());
        if (this.bodyBuffer != null) {
            this.bodyBuffer.setBuffer(this.buffer);
        }
    }

    private final class DecodingContext
    implements BodyEncoder {
        private int lastPos = 0;

        @Override
        public void open() {
        }

        @Override
        public void close() {
        }

        @Override
        public long getLargeBodySize() {
            return MessageImpl.this.buffer.writerIndex();
        }

        @Override
        public int encode(ByteBuffer bufferRead) throws ActiveMQException {
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)bufferRead);
            return this.encode(buffer, bufferRead.capacity());
        }

        @Override
        public int encode(ActiveMQBuffer bufferOut, int size) {
            bufferOut.writeBytes(MessageImpl.this.getWholeBuffer(), this.lastPos, size);
            this.lastPos += size;
            return size;
        }
    }
}

