/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import io.airlift.airline.Command;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.Artemis;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.DescribeJournal;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.CursorAckRecordEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageUpdateTXEncoding;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;

@Command(name="print", description="Print data records information (WARNING: don't use while a production server is running)")
public class PrintData
extends LockAbstract {
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        try {
            PrintData.printData(new File(this.getBinding()), new File(this.getJournal()), new File(this.getPaging()));
        }
        catch (Exception e) {
            this.treatError(e, "data", "print");
        }
        return null;
    }

    public static void printData(File bindingsDirectory, File messagesDirectory, File pagingDirectory) throws Exception {
        Artemis.printBanner();
        File serverLockFile = new File(messagesDirectory, "server.lock");
        if (serverLockFile.isFile()) {
            try {
                FileLockNodeManager fileLock = new FileLockNodeManager(messagesDirectory, false);
                fileLock.start();
                System.out.println("********************************************");
                System.out.println("Server's ID=" + fileLock.getNodeId().toString());
                System.out.println("********************************************");
                fileLock.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("********************************************");
        System.out.println("B I N D I N G S  J O U R N A L");
        System.out.println("********************************************");
        try {
            DescribeJournal.describeBindingsJournal((File)bindingsDirectory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println("********************************************");
        System.out.println("M E S S A G E S   J O U R N A L");
        System.out.println("********************************************");
        DescribeJournal describeJournal = null;
        try {
            describeJournal = DescribeJournal.describeMessagesJournal((File)messagesDirectory);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            System.out.println();
            System.out.println("********************************************");
            System.out.println("P A G I N G");
            System.out.println("********************************************");
            PrintData.printPages(pagingDirectory, describeJournal);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static void printPages(File pageDirectory, DescribeJournal describeJournal) {
        try {
            SimpleString[] stores;
            PageCursorsInfo cursorACKs = PrintData.calculateCursorsInfo(describeJournal.getRecords());
            Set<Long> pgTXs = cursorACKs.getPgTXs();
            ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
            final ExecutorService executor = Executors.newFixedThreadPool(10, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
            ExecutorFactory execfactory = new ExecutorFactory(){

                public Executor getExecutor() {
                    return executor;
                }
            };
            NullStorageManager sm = new NullStorageManager();
            PagingStoreFactoryNIO pageStoreFactory = new PagingStoreFactoryNIO((StorageManager)sm, pageDirectory, 1000L, scheduled, execfactory, false, null);
            HierarchicalObjectRepository addressSettingsRepository = new HierarchicalObjectRepository();
            addressSettingsRepository.setDefault((Object)new AddressSettings());
            PagingManagerImpl manager = new PagingManagerImpl((PagingStoreFactory)pageStoreFactory, (HierarchicalRepository)addressSettingsRepository);
            manager.start();
            for (SimpleString store : stores = manager.getStoreNames()) {
                PagingStore pgStore = manager.getPageStore(store);
                File folder = null;
                if (pgStore != null) {
                    folder = pgStore.getFolder();
                }
                System.out.println("####################################################################################################");
                System.out.println("Exploring store " + store + " folder = " + folder);
                int pgid = (int)pgStore.getFirstPage();
                for (int pg = 0; pg < pgStore.getNumberOfPages(); ++pg) {
                    System.out.println("*******   Page " + pgid);
                    Page page = pgStore.createPage(pgid);
                    page.open();
                    List msgs = page.read((StorageManager)sm);
                    page.close();
                    int msgID = 0;
                    for (PagedMessage msg : msgs) {
                        msg.initMessage((StorageManager)sm);
                        System.out.print("pg=" + pgid + ", msg=" + msgID + ",pgTX=" + msg.getTransactionID() + ",userMessageID=" + (msg.getMessage().getUserID() != null ? msg.getMessage().getUserID() : "") + ", msg=" + msg.getMessage());
                        System.out.print(",Queues = ");
                        long[] q = msg.getQueueIDs();
                        for (int i = 0; i < q.length; ++i) {
                            System.out.print(q[i]);
                            PagePositionImpl posCheck = new PagePositionImpl((long)pgid, msgID);
                            boolean acked = false;
                            Set<PagePosition> positions = cursorACKs.getCursorRecords().get(q[i]);
                            if (positions != null) {
                                acked = positions.contains(posCheck);
                            }
                            if (acked) {
                                System.out.print(" (ACK)");
                            }
                            if (cursorACKs.getCompletePages(q[i]).contains(pgid)) {
                                System.out.println(" (PG-COMPLETE)");
                            }
                            if (i + 1 >= q.length) continue;
                            System.out.print(",");
                        }
                        if (msg.getTransactionID() >= 0L && !pgTXs.contains(msg.getTransactionID())) {
                            System.out.print(", **PG_TX_NOT_FOUND**");
                        }
                        System.out.println();
                        ++msgID;
                    }
                    ++pgid;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static PageCursorsInfo calculateCursorsInfo(List<RecordInfo> records) throws Exception {
        PageCursorsInfo cursorInfo = new PageCursorsInfo();
        for (RecordInfo record : records) {
            CursorAckRecordEncoding encoding;
            byte[] data = record.data;
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
            if (record.userRecordType == 39) {
                encoding = new CursorAckRecordEncoding();
                encoding.decode(buff);
                Set<PagePosition> set = cursorInfo.getCursorRecords().get(encoding.queueID);
                if (set == null) {
                    set = new HashSet<PagePosition>();
                    cursorInfo.getCursorRecords().put(encoding.queueID, set);
                }
                set.add(encoding.position);
                continue;
            }
            if (record.userRecordType == 42) {
                encoding = new CursorAckRecordEncoding();
                encoding.decode(buff);
                Long queueID = encoding.queueID;
                Long pageNR = encoding.position.getPageNr();
                if (cursorInfo.getCompletePages(queueID).add(pageNR)) continue;
                System.err.println("Page " + pageNR + " has been already set as complete on queue " + queueID);
                continue;
            }
            if (record.userRecordType != 35) continue;
            if (record.isUpdate) {
                PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                pageUpdate.decode(buff);
                cursorInfo.getPgTXs().add(pageUpdate.pageTX);
                continue;
            }
            PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
            pageTransactionInfo.decode(buff);
            pageTransactionInfo.setRecordID(record.id);
            cursorInfo.getPgTXs().add(pageTransactionInfo.getTransactionID());
        }
        return cursorInfo;
    }

    private static class PageCursorsInfo {
        private final Map<Long, Set<PagePosition>> cursorRecords = new HashMap<Long, Set<PagePosition>>();
        private final Set<Long> pgTXs = new HashSet<Long>();
        private final Map<Long, Set<Long>> completePages = new HashMap<Long, Set<Long>>();

        public Set<Long> getPgTXs() {
            return this.pgTXs;
        }

        public Map<Long, Set<PagePosition>> getCursorRecords() {
            return this.cursorRecords;
        }

        public Map<Long, Set<Long>> getCompletePages() {
            return this.completePages;
        }

        public Set<Long> getCompletePages(Long queueID) {
            Set<Long> completePagesSet = this.completePages.get(queueID);
            if (completePagesSet == null) {
                completePagesSet = new HashSet<Long>();
                this.completePages.put(queueID, completePagesSet);
            }
            return completePagesSet;
        }
    }
}

