/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import java.util.Map;
import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.Parameter;
import org.apache.activemq.artemis.api.jms.management.DestinationControl;

public interface TopicControl
extends DestinationControl {
    @Attribute(desc="number of (durable and non-durable) subscribers for this topic")
    public int getSubscriptionCount();

    @Attribute(desc="number of durable subscribers for this topic")
    public int getDurableSubscriptionCount();

    @Attribute(desc="number of non-durable subscribers for this topic")
    public int getNonDurableSubscriptionCount();

    @Attribute(desc="number of messages for all durable subscribers for this topic")
    public int getDurableMessageCount();

    @Attribute(desc="number of messages for all non-durable subscribers for this topic")
    public int getNonDurableMessageCount();

    @Operation(desc="Returns the list of Registry bindings associated")
    public String[] getRegistryBindings();

    @Operation(desc="Adds the queue to another Registry binding")
    public void addBinding(@Parameter(name="binding", desc="the name of the binding for Registry") String var1) throws Exception;

    @Operation(desc="List all subscriptions")
    public Object[] listAllSubscriptions() throws Exception;

    @Operation(desc="List all subscriptions")
    public String listAllSubscriptionsAsJSON() throws Exception;

    @Operation(desc="List only the durable subscriptions")
    public Object[] listDurableSubscriptions() throws Exception;

    @Operation(desc="List only the durable subscriptions")
    public String listDurableSubscriptionsAsJSON() throws Exception;

    @Operation(desc="List only the non durable subscriptions")
    public Object[] listNonDurableSubscriptions() throws Exception;

    @Operation(desc="List only the non durable subscriptions")
    public String listNonDurableSubscriptionsAsJSON() throws Exception;

    @Operation(desc="List all the message for the given subscription")
    public Map<String, Object>[] listMessagesForSubscription(@Parameter(name="queueName", desc="the name of the queue representing a subscription") String var1) throws Exception;

    @Operation(desc="List all the message for the given subscription")
    public String listMessagesForSubscriptionAsJSON(@Parameter(name="queueName", desc="the name of the queue representing a subscription") String var1) throws Exception;

    @Operation(desc="Count the number of messages matching the filter for the given subscription")
    public int countMessagesForSubscription(@Parameter(name="clientID", desc="the client ID") String var1, @Parameter(name="subscriptionName", desc="the name of the durable subscription") String var2, @Parameter(name="filter", desc="a JMS filter (can be empty)") String var3) throws Exception;

    @Operation(desc="Drop a durable subscription", impact=1)
    public void dropDurableSubscription(@Parameter(name="clientID", desc="the client ID") String var1, @Parameter(name="subscriptionName", desc="the name of the durable subscription") String var2) throws Exception;

    @Operation(desc="Drop all subscriptions from this topic", impact=1)
    public void dropAllSubscriptions() throws Exception;
}

