/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.util;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.util.ByteSequence;

public class OpenWireUtil {
    public static ActiveMQBuffer toActiveMQBuffer(ByteSequence bytes) {
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)bytes.length);
        buffer.writeBytes(bytes.data, bytes.offset, bytes.length);
        return buffer;
    }

    public static SimpleString toCoreAddress(ActiveMQDestination dest) {
        if (dest.isQueue()) {
            if (dest.isTemporary()) {
                return new SimpleString("jms.tempqueue." + dest.getPhysicalName());
            }
            return new SimpleString("jms.queue." + dest.getPhysicalName());
        }
        if (dest.isTemporary()) {
            return new SimpleString("jms.temptopic." + dest.getPhysicalName());
        }
        return new SimpleString("jms.topic." + dest.getPhysicalName());
    }

    public static ActiveMQDestination toAMQAddress(ServerMessage message, ActiveMQDestination actualDestination) {
        String address = message.getAddress().toString();
        String strippedAddress = address.replace("jms.queue.", "").replace("jms.tempqueue.", "").replace("jms.topic.", "").replace("jms.temptopic.", "");
        if (actualDestination.isQueue()) {
            return new ActiveMQQueue(strippedAddress);
        }
        return new ActiveMQTopic(strippedAddress);
    }

    public static String convertWildcard(String physicalName) {
        return physicalName.replaceAll("(\\.>)+", ".#");
    }

    public static XidImpl toXID(TransactionId xaXid) {
        return OpenWireUtil.toXID((XATransactionId)xaXid);
    }

    public static XidImpl toXID(XATransactionId xaXid) {
        return new XidImpl(xaXid.getBranchQualifier(), xaXid.getFormatId(), xaXid.getGlobalTransactionId());
    }
}

