/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.InvalidDestinationException;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireMessageConverter;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.SlowConsumerDetectionListener;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.SimpleIDGenerator;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.wireformat.WireFormat;

public class AMQSession
implements SessionCallback {
    protected final IDGenerator consumerIDGenerator = new SimpleIDGenerator(0L);
    private ConnectionInfo connInfo;
    private ServerSession coreSession;
    private SessionInfo sessInfo;
    private ActiveMQServer server;
    private OpenWireConnection connection;
    private AtomicBoolean started = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledPool;
    private final OpenWireMessageConverter converter;

    public AMQSession(ConnectionInfo connInfo, SessionInfo sessInfo, ActiveMQServer server, OpenWireConnection connection, ScheduledExecutorService scheduledPool) {
        this.connInfo = connInfo;
        this.sessInfo = sessInfo;
        this.server = server;
        this.connection = connection;
        this.scheduledPool = scheduledPool;
        OpenWireFormat marshaller = (OpenWireFormat)connection.getMarshaller();
        this.converter = new OpenWireMessageConverter((WireFormat)marshaller.copy());
    }

    public boolean isClosed() {
        return this.coreSession.isClosed();
    }

    public OpenWireMessageConverter getConverter() {
        return this.converter;
    }

    public void initialize() {
        String name = this.sessInfo.getSessionId().toString();
        String username = this.connInfo.getUserName();
        String password = this.connInfo.getPassword();
        int minLargeMessageSize = Integer.MAX_VALUE;
        try {
            this.coreSession = this.server.createSession(name, username, password, minLargeMessageSize, (RemotingConnection)this.connection, true, false, false, false, null, (SessionCallback)this, true);
            long sessionId = this.sessInfo.getSessionId().getValue();
            if (sessionId == -1L) {
                this.connection.setAdvisorySession(this);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.error((Object)"error init session", (Throwable)e);
        }
    }

    public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
        if (consumer.getProtocolData() != null) {
            ((AMQConsumer)consumer.getProtocolData()).updateDeliveryCountAfterCancel(ref);
            return true;
        }
        return false;
    }

    public List<AMQConsumer> createConsumer(ConsumerInfo info, SlowConsumerDetectionListener slowConsumerDetectionListener) throws Exception {
        ActiveMQDestination dest = info.getDestination();
        ActiveMQDestination[] dests = null;
        dests = dest.isComposite() ? dest.getCompositeDestinations() : new ActiveMQDestination[]{dest};
        LinkedList<AMQConsumer> consumersList = new LinkedList<AMQConsumer>();
        for (ActiveMQDestination openWireDest : dests) {
            if (openWireDest.isQueue()) {
                SimpleString queueName = OpenWireUtil.toCoreAddress(openWireDest);
                this.getCoreServer().getJMSDestinationCreator().create(queueName);
            }
            AMQConsumer consumer = new AMQConsumer(this, openWireDest, info, this.scheduledPool);
            long nativeID = this.consumerIDGenerator.generateID();
            consumer.init(slowConsumerDetectionListener, nativeID);
            consumersList.add(consumer);
        }
        return consumersList;
    }

    public void start() {
        this.coreSession.start();
        this.started.set(true);
    }

    public void afterDelivery() throws Exception {
    }

    public void browserFinished(ServerConsumer consumer) {
        AMQConsumer theConsumer = (AMQConsumer)consumer.getProtocolData();
        if (theConsumer != null) {
            theConsumer.browseFinished();
        }
    }

    public boolean isWritable(ReadyListener callback) {
        return this.connection.isWritable(callback);
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    public int sendMessage(MessageReference reference, ServerMessage message, ServerConsumer consumer, int deliveryCount) {
        AMQConsumer theConsumer = (AMQConsumer)consumer.getProtocolData();
        return theConsumer.handleDeliver(reference, message, deliveryCount);
    }

    public int sendLargeMessage(MessageReference reference, ServerMessage message, ServerConsumer consumerID, long bodySize, int deliveryCount) {
        return 0;
    }

    public int sendLargeMessageContinuation(ServerConsumer consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    public void closed() {
    }

    public boolean hasCredits(ServerConsumer consumer) {
        AMQConsumer amqConsumer = null;
        if (consumer.getProtocolData() != null) {
            amqConsumer = (AMQConsumer)consumer.getProtocolData();
        }
        return amqConsumer != null && amqConsumer.hasCredits();
    }

    public void disconnect(ServerConsumer consumerId, String queueName) {
    }

    public void send(final ProducerInfo producerInfo, final org.apache.activemq.command.Message messageSend, boolean sendProducerAck) throws Exception {
        Connection transportConnection;
        messageSend.setBrokerInTime(System.currentTimeMillis());
        ActiveMQDestination destination = messageSend.getDestination();
        ActiveMQDestination[] actualDestinations = null;
        if (destination.isComposite()) {
            actualDestinations = destination.getCompositeDestinations();
            messageSend.setOriginalDestination(destination);
        } else {
            actualDestinations = new ActiveMQDestination[]{destination};
        }
        ServerMessage originalCoreMsg = this.getConverter().inbound(messageSend);
        if (this.connection.getContext().isFaultTolerant() && !messageSend.getProperties().containsKey(Message.HDR_DUPLICATE_DETECTION_ID)) {
            originalCoreMsg.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID.toString(), messageSend.getMessageId().toString());
        }
        Object runnable = sendProducerAck ? new Runnable(){

            @Override
            public void run() {
                try {
                    ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), messageSend.getSize());
                    AMQSession.this.connection.dispatchSync((Command)ack);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn((Object)e.getMessage(), (Throwable)e);
                    AMQSession.this.connection.sendException(e);
                }
            }
        } : ((transportConnection = this.connection.getTransportConnection()) == null ? null : new Runnable(){

            @Override
            public void run() {
                transportConnection.setAutoRead(true);
            }
        });
        this.internalSend(actualDestinations, originalCoreMsg, (Runnable)runnable);
    }

    private void internalSend(ActiveMQDestination[] actualDestinations, ServerMessage originalCoreMsg, final Runnable onComplete) throws Exception {
        int i;
        Runnable runToUse;
        if (actualDestinations.length <= 1 || onComplete == null) {
            runToUse = onComplete;
        } else {
            final AtomicInteger count = new AtomicInteger(actualDestinations.length);
            runToUse = new Runnable(){

                @Override
                public void run() {
                    if (count.decrementAndGet() == 0) {
                        onComplete.run();
                    }
                }
            };
        }
        SimpleString[] addresses = new SimpleString[actualDestinations.length];
        PagingStore[] pagingStores = new PagingStore[actualDestinations.length];
        for (i = 0; i < actualDestinations.length; ++i) {
            ActiveMQDestination dest = actualDestinations[i];
            addresses[i] = OpenWireUtil.toCoreAddress(dest);
            pagingStores[i] = this.server.getPagingManager().getPageStore(addresses[i]);
            if (pagingStores[i].getAddressFullMessagePolicy() != AddressFullMessagePolicy.FAIL || !pagingStores[i].isFull()) continue;
            throw new ResourceAllocationException("Queue is full");
        }
        for (i = 0; i < actualDestinations.length; ++i) {
            RoutingStatus result;
            ServerMessage coreMsg = originalCoreMsg.copy();
            coreMsg.setAddress(addresses[i]);
            PagingStore store = pagingStores[i];
            if (store.isFull()) {
                this.connection.getTransportConnection().setAutoRead(false);
            }
            if ((result = this.getCoreSession().send(coreMsg, false, actualDestinations[i].isTemporary())) == RoutingStatus.NO_BINDINGS && actualDestinations[i].isQueue()) {
                throw new InvalidDestinationException("Cannot publish to a non-existent Destination: " + actualDestinations[i]);
            }
            if (runToUse == null) continue;
            store.checkMemory(runToUse);
        }
    }

    public ServerSession getCoreSession() {
        return this.coreSession;
    }

    public ActiveMQServer getCoreServer() {
        return this.server;
    }

    public WireFormat getMarshaller() {
        return this.connection.getMarshaller();
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    public void disableSecurity() {
        this.coreSession.disableSecurity();
    }

    public void deliverMessage(MessageDispatch dispatch) {
        this.connection.deliverMessage(dispatch);
    }

    public void close() throws Exception {
        this.coreSession.close(false);
    }

    public OpenWireConnection getConnection() {
        return this.connection;
    }
}

