/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra.inflow;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;

public class ActiveMQActivationSpec
extends ConnectionFactoryProperties
implements ActivationSpec,
Serializable {
    private static final long serialVersionUID = -7997041053897964654L;
    private static final int DEFAULT_MAX_SESSION = 15;
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    public String strConnectorClassName;
    public String strConnectionParameters;
    private ActiveMQResourceAdapter ra;
    private String connectionFactoryLookup;
    private String destination;
    private String destinationType;
    private String messageSelector;
    private int acknowledgeMode;
    private boolean subscriptionDurability;
    private String subscriptionName;
    private boolean shareSubscriptions;
    private String user;
    private String password;
    private Integer maxSession;
    private Integer transactionTimeout;
    private Boolean useJNDI = true;
    private String jndiParams = null;
    private Hashtable<String, String> parsedJndiParams;
    private Boolean localTx;
    private Integer setupAttempts;
    private Long setupInterval;
    private Boolean rebalanceConnections = false;

    public ActiveMQActivationSpec() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor()");
        }
        this.ra = null;
        this.destination = null;
        this.destinationType = null;
        this.messageSelector = null;
        this.acknowledgeMode = 1;
        this.subscriptionDurability = false;
        this.subscriptionName = null;
        this.user = null;
        this.password = null;
        this.maxSession = 15;
        this.transactionTimeout = 0;
    }

    public ResourceAdapter getResourceAdapter() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getResourceAdapter()");
        }
        return this.ra;
    }

    public boolean isUseJNDI() {
        if (this.useJNDI == null) {
            return this.ra.isUseJNDI();
        }
        return this.useJNDI;
    }

    public void setUseJNDI(boolean value) {
        this.useJNDI = value;
    }

    public String getJndiParams() {
        if (this.jndiParams == null) {
            return this.ra.getJndiParams();
        }
        return this.jndiParams;
    }

    public void setJndiParams(String jndiParams) {
        this.jndiParams = jndiParams;
        this.parsedJndiParams = ActiveMQRaUtils.parseHashtableConfig(jndiParams);
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        if (this.parsedJndiParams == null) {
            return this.ra.getParsedJndiParams();
        }
        return this.parsedJndiParams;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setResourceAdapter(" + ra + ")");
        }
        if (ra == null || !(ra instanceof ActiveMQResourceAdapter)) {
            throw new ResourceException("Resource adapter is " + ra);
        }
        this.ra = (ActiveMQResourceAdapter)ra;
    }

    public String getConnectionFactoryLookup() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConnectionFactoryLookup() ->" + this.connectionFactoryLookup);
        }
        return this.connectionFactoryLookup;
    }

    public void setConnectionFactoryLookup(String value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConnectionFactoryLookup(" + value + ")");
        }
        this.connectionFactoryLookup = value;
    }

    public String getDestination() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDestination()");
        }
        return this.destination;
    }

    public void setDestination(String value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDestination(" + value + ")");
        }
        this.destination = value;
    }

    public String getDestinationLookup() {
        return this.getDestination();
    }

    public void setDestinationLookup(String value) {
        this.setDestination(value);
        this.setUseJNDI(true);
    }

    public String getDestinationType() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDestinationType()");
        }
        return this.destinationType;
    }

    public void setDestinationType(String value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDestinationType(" + value + ")");
        }
        this.destinationType = value;
    }

    public String getMessageSelector() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMessageSelector()");
        }
        return this.messageSelector;
    }

    public void setMessageSelector(String value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setMessageSelector(" + value + ")");
        }
        this.messageSelector = value;
    }

    public String getAcknowledgeMode() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getAcknowledgeMode()");
        }
        if (3 == this.acknowledgeMode) {
            return "Dups-ok-acknowledge";
        }
        return "Auto-acknowledge";
    }

    public void setAcknowledgeMode(String value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setAcknowledgeMode(" + value + ")");
        }
        if ("DUPS_OK_ACKNOWLEDGE".equalsIgnoreCase(value) || "Dups-ok-acknowledge".equalsIgnoreCase(value)) {
            this.acknowledgeMode = 3;
        } else if ("AUTO_ACKNOWLEDGE".equalsIgnoreCase(value) || "Auto-acknowledge".equalsIgnoreCase(value)) {
            this.acknowledgeMode = 1;
        } else {
            throw new IllegalArgumentException("Unsupported acknowledgement mode " + value);
        }
    }

    public int getAcknowledgeModeInt() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getAcknowledgeMode()");
        }
        return this.acknowledgeMode;
    }

    public String getSubscriptionDurability() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getSubscriptionDurability()");
        }
        if (this.subscriptionDurability) {
            return "Durable";
        }
        return "NonDurable";
    }

    public void setSubscriptionDurability(String value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setSubscriptionDurability(" + value + ")");
        }
        this.subscriptionDurability = "Durable".equals(value);
    }

    public boolean isSubscriptionDurable() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isSubscriptionDurable()");
        }
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getSubscriptionName()");
        }
        return this.subscriptionName;
    }

    public void setSubscriptionName(String value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setSubscriptionName(" + value + ")");
        }
        this.subscriptionName = value;
    }

    public boolean isShareSubscriptions() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isShareSubscriptions() = " + this.shareSubscriptions);
        }
        return this.shareSubscriptions;
    }

    public void setShareSubscriptions(boolean shareSubscriptions) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setShareSubscriptions(" + shareSubscriptions + ")");
        }
        this.shareSubscriptions = shareSubscriptions;
    }

    public String getUser() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getUser()");
        }
        if (this.user == null) {
            return this.ra.getUserName();
        }
        return this.user;
    }

    public void setUser(String value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setUser(" + value + ")");
        }
        this.user = value;
    }

    public String getPassword() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getPassword()");
        }
        if (this.password == null) {
            return this.ra.getPassword();
        }
        return this.password;
    }

    public String getOwnPassword() {
        return this.password;
    }

    public void setPassword(String value) throws Exception {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.password = value;
    }

    public Integer getMaxSession() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMaxSession()");
        }
        if (this.maxSession == null) {
            return 15;
        }
        return this.maxSession;
    }

    public void setMaxSession(Integer value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setMaxSession(" + value + ")");
        }
        this.maxSession = value;
    }

    public Integer getTransactionTimeout() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getTransactionTimeout()");
        }
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(Integer value) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setTransactionTimeout(" + value + ")");
        }
        this.transactionTimeout = value;
    }

    public Boolean isUseLocalTx() {
        if (this.localTx == null) {
            return this.ra.getUseLocalTx();
        }
        return this.localTx;
    }

    public void setUseLocalTx(Boolean localTx) {
        this.localTx = localTx;
    }

    public boolean isRebalanceConnections() {
        return this.rebalanceConnections;
    }

    public void setRebalanceConnections(boolean rebalanceConnections) {
        this.rebalanceConnections = rebalanceConnections;
    }

    public int getSetupAttempts() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getSetupAttempts()");
        }
        if (this.setupAttempts == null) {
            return this.ra.getSetupAttempts();
        }
        return this.setupAttempts;
    }

    public void setSetupAttempts(int setupAttempts) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setSetupAttempts(" + setupAttempts + ")");
        }
        this.setupAttempts = setupAttempts;
    }

    public long getSetupInterval() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getSetupInterval()");
        }
        if (this.setupInterval == null) {
            return this.ra.getSetupInterval();
        }
        return this.setupInterval;
    }

    public void setSetupInterval(long setupInterval) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setSetupInterval(" + setupInterval + ")");
        }
        this.setupInterval = setupInterval;
    }

    public void setClientId(String clientId) {
        this.setClientID(clientId);
    }

    public void validate() throws InvalidPropertyException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("validate()");
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<PropertyDescriptor> propsNotSet = new ArrayList<PropertyDescriptor>();
        try {
            if (this.destination == null || this.destination.trim().equals("")) {
                propsNotSet.add(new PropertyDescriptor("destination", ActiveMQActivationSpec.class));
                errorMessages.add("Destination is mandatory.");
            }
            if (this.destinationType != null && !Topic.class.getName().equals(this.destinationType) && !Queue.class.getName().equals(this.destinationType)) {
                propsNotSet.add(new PropertyDescriptor("destinationType", ActiveMQActivationSpec.class));
                errorMessages.add("If set, the destinationType must be either 'javax.jms.Topic' or 'javax.jms.Queue'.");
            }
            if ((this.destinationType == null || this.destinationType.length() == 0 || Topic.class.getName().equals(this.destinationType)) && this.isSubscriptionDurable() && (this.subscriptionName == null || this.subscriptionName.length() == 0)) {
                propsNotSet.add(new PropertyDescriptor("subscriptionName", ActiveMQActivationSpec.class));
                errorMessages.add("If subscription is durable then subscription name must be specified.");
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        if (propsNotSet.size() > 0) {
            StringBuffer b = new StringBuffer();
            b.append("Invalid settings:");
            Iterator iter = errorMessages.iterator();
            while (iter.hasNext()) {
                b.append(" ");
                b.append((String)iter.next());
            }
            InvalidPropertyException e = new InvalidPropertyException(b.toString());
            PropertyDescriptor[] descriptors = propsNotSet.toArray(new PropertyDescriptor[propsNotSet.size()]);
            e.setInvalidPropertyDescriptors(descriptors);
            throw e;
        }
    }

    public String getConnectorClassName() {
        return this.strConnectorClassName;
    }

    public void setConnectorClassName(String connectorClassName) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConnectorClassName(" + connectorClassName + ")");
        }
        this.strConnectorClassName = connectorClassName;
        this.setParsedConnectorClassNames(ActiveMQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getConnectionParameters() {
        return this.strConnectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.setParsedConnectionParameters(ActiveMQRaUtils.parseConfig(configuration));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ActiveMQActivationSpec.class.getName()).append('(');
        buffer.append("ra=").append(this.ra);
        if (this.messageSelector != null) {
            buffer.append(" connectionFactoryLookup=").append(this.connectionFactoryLookup);
        }
        buffer.append(" destination=").append(this.destination);
        buffer.append(" destinationType=").append(this.destinationType);
        if (this.messageSelector != null) {
            buffer.append(" selector=").append(this.messageSelector);
        }
        buffer.append(" ack=").append(this.getAcknowledgeMode());
        buffer.append(" durable=").append(this.subscriptionDurability);
        buffer.append(" clientID=").append(this.getClientID());
        if (this.subscriptionName != null) {
            buffer.append(" subscription=").append(this.subscriptionName);
        }
        buffer.append(" user=").append(this.user);
        if (this.password != null) {
            buffer.append(" password=").append("****");
        }
        buffer.append(" maxSession=").append(this.maxSession);
        buffer.append(')');
        return buffer.toString();
    }

    public void setUseDLQ(boolean b) {
    }

    public void setDLQJNDIName(String name) {
    }

    public void setDLQHandler(String handler) {
    }

    public void setDLQMaxResent(int maxResent) {
    }

    public void setProviderAdapterJNDI(String jndi) {
    }

    public void setKeepAlive(boolean keepAlive) {
    }

    public void setKeepAliveMillis(long keepAliveMillis) {
    }

    public void setReconnectInterval(long interval) {
    }

    public void setMinSession(Integer value) {
    }

    public void setMaxMessages(Integer value) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActiveMQActivationSpec that = (ActiveMQActivationSpec)o;
        if (this.acknowledgeMode != that.acknowledgeMode) {
            return false;
        }
        if (this.subscriptionDurability != that.subscriptionDurability) {
            return false;
        }
        if (this.shareSubscriptions != that.shareSubscriptions) {
            return false;
        }
        if (this.strConnectorClassName != null ? !this.strConnectorClassName.equals(that.strConnectorClassName) : that.strConnectorClassName != null) {
            return false;
        }
        if (this.strConnectionParameters != null ? !this.strConnectionParameters.equals(that.strConnectionParameters) : that.strConnectionParameters != null) {
            return false;
        }
        if (this.ra != null ? !this.ra.equals(that.ra) : that.ra != null) {
            return false;
        }
        if (this.connectionFactoryLookup != null ? !this.connectionFactoryLookup.equals(that.connectionFactoryLookup) : that.connectionFactoryLookup != null) {
            return false;
        }
        if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) {
            return false;
        }
        if (this.destinationType != null ? !this.destinationType.equals(that.destinationType) : that.destinationType != null) {
            return false;
        }
        if (this.messageSelector != null ? !this.messageSelector.equals(that.messageSelector) : that.messageSelector != null) {
            return false;
        }
        if (this.subscriptionName != null ? !this.subscriptionName.equals(that.subscriptionName) : that.subscriptionName != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.maxSession != null ? !this.maxSession.equals(that.maxSession) : that.maxSession != null) {
            return false;
        }
        if (this.transactionTimeout != null ? !this.transactionTimeout.equals(that.transactionTimeout) : that.transactionTimeout != null) {
            return false;
        }
        if (this.useJNDI != null ? !this.useJNDI.equals(that.useJNDI) : that.useJNDI != null) {
            return false;
        }
        if (this.jndiParams != null ? !this.jndiParams.equals(that.jndiParams) : that.jndiParams != null) {
            return false;
        }
        if (this.parsedJndiParams != null ? !this.parsedJndiParams.equals(that.parsedJndiParams) : that.parsedJndiParams != null) {
            return false;
        }
        if (this.localTx != null ? !this.localTx.equals(that.localTx) : that.localTx != null) {
            return false;
        }
        if (this.rebalanceConnections != null ? !this.rebalanceConnections.equals(that.rebalanceConnections) : that.rebalanceConnections != null) {
            return false;
        }
        if (this.setupAttempts != null ? !this.setupAttempts.equals(that.setupAttempts) : that.setupAttempts != null) {
            return false;
        }
        return !(this.setupInterval == null ? that.setupInterval != null : !this.setupInterval.equals(that.setupInterval));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.strConnectorClassName != null ? this.strConnectorClassName.hashCode() : 0);
        result = 31 * result + (this.strConnectionParameters != null ? this.strConnectionParameters.hashCode() : 0);
        result = 31 * result + (this.ra != null ? this.ra.hashCode() : 0);
        result = 31 * result + (this.connectionFactoryLookup != null ? this.connectionFactoryLookup.hashCode() : 0);
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        result = 31 * result + (this.destinationType != null ? this.destinationType.hashCode() : 0);
        result = 31 * result + (this.messageSelector != null ? this.messageSelector.hashCode() : 0);
        result = 31 * result + this.acknowledgeMode;
        result = 31 * result + (this.subscriptionDurability ? 1 : 0);
        result = 31 * result + (this.subscriptionName != null ? this.subscriptionName.hashCode() : 0);
        result = 31 * result + (this.shareSubscriptions ? 1 : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.maxSession != null ? this.maxSession.hashCode() : 0);
        result = 31 * result + (this.transactionTimeout != null ? this.transactionTimeout.hashCode() : 0);
        result = 31 * result + (this.useJNDI != null ? this.useJNDI.hashCode() : 0);
        result = 31 * result + (this.jndiParams != null ? this.jndiParams.hashCode() : 0);
        result = 31 * result + (this.parsedJndiParams != null ? this.parsedJndiParams.hashCode() : 0);
        result = 31 * result + (this.localTx != null ? this.localTx.hashCode() : 0);
        result = 31 * result + (this.rebalanceConnections != null ? this.rebalanceConnections.hashCode() : 0);
        result = 31 * result + (this.setupAttempts != null ? this.setupAttempts.hashCode() : 0);
        result = 31 * result + (this.setupInterval != null ? this.setupInterval.hashCode() : 0);
        return result;
    }
}

