/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security;

import io.netty.channel.Channel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager2;
import org.apache.activemq.artemis.spi.core.security.jaas.JaasCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.utils.CertificateUtil;
import org.jboss.logging.Logger;

public class ActiveMQJAASSecurityManager
implements ActiveMQSecurityManager2 {
    private static final Logger logger = Logger.getLogger(ActiveMQJAASSecurityManager.class);
    private static final String WILDCARD = "*";
    private String configurationName;
    private SecurityConfiguration configuration;
    private String rolePrincipalClass = "org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal";

    public ActiveMQJAASSecurityManager() {
    }

    public ActiveMQJAASSecurityManager(String configurationName) {
        this.configurationName = configurationName;
    }

    public ActiveMQJAASSecurityManager(String configurationName, SecurityConfiguration configuration) {
        this.configurationName = configurationName;
        this.configuration = configuration;
    }

    @Override
    public boolean validateUser(String user, String password) {
        return this.validateUser(user, password, null);
    }

    @Override
    public boolean validateUser(String user, String password, X509Certificate[] certificates) {
        try {
            this.getAuthenticatedSubject(user, password, certificates);
            return true;
        }
        catch (LoginException e) {
            logger.info((Object)("Couldn't validate user: " + e.getMessage()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Couldn't validate user", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        throw new UnsupportedOperationException("Invoke validateUserAndRole(String, String, Set<Role>, CheckType, String, RemotingConnection) instead");
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType, String address, RemotingConnection connection) {
        Subject localSubject;
        X509Certificate[] certificates = null;
        if (connection != null && connection.getTransportConnection() instanceof NettyConnection) {
            certificates = CertificateUtil.getCertsFromChannel((Channel)((NettyConnection)connection.getTransportConnection()).getChannel());
        }
        try {
            localSubject = this.getAuthenticatedSubject(user, password, certificates);
        }
        catch (LoginException e) {
            logger.debug((Object)"Couldn't validate user", (Throwable)e);
            return false;
        }
        boolean authorized = false;
        if (localSubject != null) {
            Set<RolePrincipal> rolesWithPermission = this.getPrincipalsInRole(checkType, roles);
            HashSet<Principal> rolesForSubject = new HashSet<Principal>();
            try {
                rolesForSubject.addAll(localSubject.getPrincipals(Class.forName(this.rolePrincipalClass).asSubclass(Principal.class)));
            }
            catch (Exception e) {
                logger.info((Object)"Can't find roles for the subject", (Throwable)e);
            }
            if (rolesForSubject.size() > 0 && rolesWithPermission.size() > 0) {
                Iterator rolesForSubjectIter = rolesForSubject.iterator();
                while (!authorized && rolesForSubjectIter.hasNext()) {
                    Iterator<RolePrincipal> rolesWithPermissionIter = rolesWithPermission.iterator();
                    Principal subjectRole = (Principal)rolesForSubjectIter.next();
                    while (!authorized && rolesWithPermissionIter.hasNext()) {
                        Principal roleWithPermission = rolesWithPermissionIter.next();
                        authorized = subjectRole.equals(roleWithPermission);
                    }
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("user " + (authorized ? " is " : " is NOT ") + "authorized"));
            }
        }
        return authorized;
    }

    private Subject getAuthenticatedSubject(String user, String password, X509Certificate[] certificates) throws LoginException {
        LoginContext lc = new LoginContext(this.configurationName, null, new JaasCallbackHandler(user, password, certificates), this.configuration);
        lc.login();
        return lc.getSubject();
    }

    private Set<RolePrincipal> getPrincipalsInRole(CheckType checkType, Set<Role> roles) {
        HashSet<RolePrincipal> principals = new HashSet<RolePrincipal>();
        for (Role role : roles) {
            if (!checkType.hasRole(role)) continue;
            try {
                principals.add((RolePrincipal)ActiveMQJAASSecurityManager.createGroupPrincipal(role.getName(), this.rolePrincipalClass));
            }
            catch (Exception e) {
                logger.info((Object)"Can't add role principal", (Throwable)e);
            }
        }
        return principals;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setConfiguration(SecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    public SecurityConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new SecurityConfiguration();
        }
        return this.configuration;
    }

    public String getRolePrincipalClass() {
        return this.rolePrincipalClass;
    }

    public void setRolePrincipalClass(String rolePrincipalClass) {
        this.rolePrincipalClass = rolePrincipalClass;
    }

    public static Object createGroupPrincipal(String name, String groupClass) throws Exception {
        Object instance;
        Class<?>[] paramTypes;
        int i;
        if (WILDCARD.equals(name)) {
            return new Principal(){

                @Override
                public String getName() {
                    return ActiveMQJAASSecurityManager.WILDCARD;
                }

                @Override
                public boolean equals(Object other) {
                    return true;
                }

                @Override
                public int hashCode() {
                    return ActiveMQJAASSecurityManager.WILDCARD.hashCode();
                }
            };
        }
        Object[] param = new Object[]{name};
        Class<?> cls = Class.forName(groupClass);
        Constructor<?>[] constructors = cls.getConstructors();
        for (i = 0; !(i >= constructors.length || (paramTypes = constructors[i].getParameterTypes()).length != 0 && paramTypes[0].equals(String.class)); ++i) {
        }
        if (i < constructors.length) {
            instance = constructors[i].newInstance(param);
        } else {
            Class<?>[] paramTypes2;
            instance = cls.newInstance();
            Method[] methods = cls.getMethods();
            i = 0;
            for (i = 0; !(i >= methods.length || (paramTypes2 = methods[i].getParameterTypes()).length != 0 && methods[i].getName().equals("setName") && paramTypes2[0].equals(String.class)); ++i) {
            }
            if (i < methods.length) {
                methods[i].invoke(instance, param);
            } else {
                throw new NoSuchMethodException();
            }
        }
        return instance;
    }
}

