/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.LinkedListIterator;
import org.apache.activemq.artemis.utils.ReferenceCounter;

public interface Queue
extends Bindable {
    public SimpleString getName();

    public long getID();

    public Filter getFilter();

    public PageSubscription getPageSubscription();

    public boolean isDurable();

    public boolean isTemporary();

    public boolean isAutoCreated();

    public void addConsumer(Consumer var1) throws Exception;

    public void removeConsumer(Consumer var1);

    public int getConsumerCount();

    public void setConsumersRefCount(ReferenceCounter var1);

    public ReferenceCounter getConsumersRefCount();

    public void reload(MessageReference var1);

    public void addTail(MessageReference var1);

    public void addTail(MessageReference var1, boolean var2);

    public void addHead(MessageReference var1, boolean var2);

    public void addHead(List<MessageReference> var1, boolean var2);

    public void acknowledge(MessageReference var1) throws Exception;

    public void acknowledge(Transaction var1, MessageReference var2) throws Exception;

    public void reacknowledge(Transaction var1, MessageReference var2) throws Exception;

    public void cancel(Transaction var1, MessageReference var2);

    public void cancel(Transaction var1, MessageReference var2, boolean var3);

    public void cancel(MessageReference var1, long var2) throws Exception;

    public void deliverAsync();

    public void unproposed(SimpleString var1);

    public void forceDelivery();

    public void deleteQueue() throws Exception;

    public void deleteQueue(boolean var1) throws Exception;

    public void destroyPaging() throws Exception;

    public long getMessageCount();

    public int getDeliveringCount();

    public void referenceHandled();

    public int getScheduledCount();

    public List<MessageReference> getScheduledMessages();

    public Map<String, List<MessageReference>> getDeliveringMessages();

    public long getMessagesAdded();

    public long getMessagesAcknowledged();

    public MessageReference removeReferenceWithID(long var1) throws Exception;

    public MessageReference getReference(long var1) throws ActiveMQException;

    public int deleteAllReferences() throws Exception;

    public int deleteAllReferences(int var1) throws Exception;

    public boolean deleteReference(long var1) throws Exception;

    public int deleteMatchingReferences(Filter var1) throws Exception;

    public int deleteMatchingReferences(int var1, Filter var2) throws Exception;

    public boolean expireReference(long var1) throws Exception;

    public int expireReferences(Filter var1) throws Exception;

    public void expireReferences() throws Exception;

    public void expire(MessageReference var1) throws Exception;

    public boolean sendMessageToDeadLetterAddress(long var1) throws Exception;

    public int sendMessagesToDeadLetterAddress(Filter var1) throws Exception;

    public void sendToDeadLetterAddress(Transaction var1, MessageReference var2) throws Exception;

    public boolean changeReferencePriority(long var1, byte var3) throws Exception;

    public int changeReferencesPriority(Filter var1, byte var2) throws Exception;

    public boolean moveReference(long var1, SimpleString var3) throws Exception;

    public boolean moveReference(long var1, SimpleString var3, boolean var4) throws Exception;

    public int moveReferences(Filter var1, SimpleString var2) throws Exception;

    public int moveReferences(int var1, Filter var2, SimpleString var3, boolean var4) throws Exception;

    public int retryMessages(Filter var1) throws Exception;

    public void addRedistributor(long var1);

    public void cancelRedistributor() throws Exception;

    public boolean hasMatchingConsumer(ServerMessage var1);

    public Collection<Consumer> getConsumers();

    public boolean checkRedelivery(MessageReference var1, long var2, boolean var4) throws Exception;

    public LinkedListIterator<MessageReference> iterator();

    public LinkedListIterator<MessageReference> totalIterator();

    public SimpleString getExpiryAddress();

    public void pause();

    public void resume();

    public boolean isPaused();

    public Executor getExecutor();

    public void resetAllIterators();

    public boolean flushExecutor();

    public void close() throws Exception;

    public boolean isDirectDeliver();

    public SimpleString getAddress();

    public boolean isInternalQueue();

    public void setInternalQueue(boolean var1);

    public void resetMessagesAdded();

    public void resetMessagesAcknowledged();

    public void incrementMesssagesAdded();

    public void deliverScheduledMessages() throws ActiveMQException;

    public void postAcknowledge(MessageReference var1);

    public float getRate();

    public SimpleString getUser();
}

