/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Address;
import org.apache.activemq.artemis.core.postoffice.impl.WildcardAddressManager;

public class AddressImpl
implements Address {
    private final SimpleString address;
    private final SimpleString[] addressParts;
    private final boolean containsWildCard;
    private final List<Address> linkedAddresses = new ArrayList<Address>();

    public AddressImpl(SimpleString address) {
        this.address = address;
        this.addressParts = address.split('.');
        this.containsWildCard = address.contains('*') || address.contains('#');
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public SimpleString[] getAddressParts() {
        return this.addressParts;
    }

    @Override
    public boolean containsWildCard() {
        return this.containsWildCard;
    }

    @Override
    public List<Address> getLinkedAddresses() {
        return this.linkedAddresses;
    }

    @Override
    public void addLinkedAddress(Address address) {
        if (!this.linkedAddresses.contains(address)) {
            this.linkedAddresses.add(address);
        }
    }

    @Override
    public void removeLinkedAddress(Address actualAddress) {
        this.linkedAddresses.remove(actualAddress);
    }

    @Override
    public boolean matches(Address add) {
        if (this.containsWildCard == add.containsWildCard()) {
            return this.address.equals((Object)add.getAddress());
        }
        int pos = 0;
        int matchPos = 0;
        while (matchPos < add.getAddressParts().length) {
            if (pos >= this.addressParts.length) {
                return pos + 1 == add.getAddressParts().length && add.getAddressParts()[pos].equals((Object)WildcardAddressManager.ANY_WORDS_SIMPLESTRING);
            }
            SimpleString curr = this.addressParts[pos];
            SimpleString next = this.addressParts.length > pos + 1 ? this.addressParts[pos + 1] : null;
            SimpleString currMatch = add.getAddressParts()[matchPos];
            if (currMatch.equals((Object)WildcardAddressManager.SINGLE_WORD_SIMPLESTRING)) {
                ++pos;
                ++matchPos;
                continue;
            }
            if (currMatch.equals((Object)WildcardAddressManager.ANY_WORDS_SIMPLESTRING)) {
                if (matchPos == this.addressParts.length - 1) {
                    ++pos;
                    ++matchPos;
                    continue;
                }
                if (next == null) {
                    return false;
                }
                if (matchPos == add.getAddressParts().length - 1) {
                    return true;
                }
                SimpleString nextToMatch = add.getAddressParts()[matchPos + 1];
                while (curr != null && !curr.equals((Object)nextToMatch)) {
                    curr = next;
                    next = this.addressParts.length > ++pos + 1 ? this.addressParts[pos + 1] : null;
                }
                if (curr == null) {
                    return false;
                }
                ++matchPos;
                continue;
            }
            if (!curr.equals((Object)currMatch)) {
                return false;
            }
            ++pos;
            ++matchPos;
        }
        return pos == this.addressParts.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressImpl address1 = (AddressImpl)o;
        return this.address.equals((Object)address1.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

