/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;

public class PersistentQueueBindingEncoding
implements EncodingSupport,
QueueBindingInfo {
    public long id;
    public SimpleString name;
    public SimpleString address;
    public SimpleString filterString;
    public boolean autoCreated;
    public SimpleString user;

    public PersistentQueueBindingEncoding() {
    }

    public String toString() {
        return "PersistentQueueBindingEncoding [id=" + this.id + ", name=" + this.name + ", address=" + this.address + ", filterString=" + this.filterString + ", user=" + this.user + ", autoCreated=" + this.autoCreated + "]";
    }

    public PersistentQueueBindingEncoding(SimpleString name, SimpleString address, SimpleString filterString, SimpleString user, boolean autoCreated) {
        this.name = name;
        this.address = address;
        this.filterString = filterString;
        this.user = user;
        this.autoCreated = autoCreated;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void replaceQueueName(SimpleString newName) {
        this.name = newName;
    }

    @Override
    public SimpleString getFilterString() {
        return this.filterString;
    }

    @Override
    public SimpleString getQueueName() {
        return this.name;
    }

    @Override
    public SimpleString getUser() {
        return this.user;
    }

    @Override
    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readSimpleString();
        this.address = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        String metadata = buffer.readNullableSimpleString().toString();
        if (metadata != null) {
            String[] elements;
            for (String element : elements = metadata.split(";")) {
                String[] keyValuePair = element.split("=");
                if (keyValuePair.length != 2 || !keyValuePair[0].equals("user")) continue;
                this.user = SimpleString.toSimpleString((String)keyValuePair[1]);
            }
        }
        this.autoCreated = buffer.readBoolean();
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.name);
        buffer.writeSimpleString(this.address);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeNullableSimpleString(this.createMetadata());
        buffer.writeBoolean(this.autoCreated);
    }

    public int getEncodeSize() {
        return SimpleString.sizeofString((SimpleString)this.name) + SimpleString.sizeofString((SimpleString)this.address) + SimpleString.sizeofNullableString((SimpleString)this.filterString) + 1 + SimpleString.sizeofNullableString((SimpleString)this.createMetadata());
    }

    private SimpleString createMetadata() {
        StringBuilder metadata = new StringBuilder();
        metadata.append("user=").append((CharSequence)this.user).append(";");
        return SimpleString.toSimpleString((String)metadata.toString());
    }
}

