/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.MessageCounterInfo;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.messagecounter.MessageCounter;
import org.apache.activemq.artemis.core.messagecounter.impl.MessageCounterHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.LinkedListIterator;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.json.JSONArray;
import org.apache.activemq.artemis.utils.json.JSONException;
import org.apache.activemq.artemis.utils.json.JSONObject;

public class QueueControlImpl
extends AbstractControl
implements QueueControl {
    public static final int FLUSH_LIMIT = 500;
    private final Queue queue;
    private final String address;
    private final PostOffice postOffice;
    private final StorageManager storageManager;
    private final SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private MessageCounter counter;

    private static String toJSON(Map<String, Object>[] messages) {
        JSONArray array = QueueControlImpl.toJSONMsgArray(messages);
        return array.toString();
    }

    private static JSONArray toJSONMsgArray(Map<String, Object>[] messages) {
        JSONArray array = new JSONArray();
        for (Map<String, Object> message : messages) {
            array.put((Object)new JSONObject(message));
        }
        return array;
    }

    private static String toJSON(Map<String, Map<String, Object>[]> messages) {
        try {
            JSONArray arrayReturn = new JSONArray();
            for (Map.Entry<String, Map<String, Object>[]> entry : messages.entrySet()) {
                JSONObject objectItem = new JSONObject();
                objectItem.put("consumerName", (Object)entry.getKey());
                objectItem.put("elements", (Object)QueueControlImpl.toJSONMsgArray(entry.getValue()));
                arrayReturn.put((Object)objectItem);
            }
            return arrayReturn.toString();
        }
        catch (JSONException e) {
            return "Invalid conversion " + e.toString();
        }
    }

    public QueueControlImpl(Queue queue, String address, PostOffice postOffice, StorageManager storageManager, SecurityStore securityStore, HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
        super(QueueControl.class, storageManager);
        this.queue = queue;
        this.address = address;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.securityStore = securityStore;
        this.addressSettingsRepository = addressSettingsRepository;
    }

    public void setMessageCounter(MessageCounter counter) {
        this.counter = counter;
    }

    public String getName() {
        this.clearIO();
        try {
            String string = this.queue.getName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getAddress() {
        this.checkStarted();
        return this.address;
    }

    public String getFilter() {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = this.queue.getFilter();
            String string = filter != null ? filter.getFilterString().toString() : null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isDurable() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isDurable();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isTemporary() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isTemporary();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessageCount() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessageCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getConsumerCount() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getConsumerCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getDeliveringCount() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getDeliveringCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessagesAdded() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessagesAdded();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessagesAcknowledged() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessagesAcknowledged();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getID() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getID();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getScheduledCount() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getScheduledCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getDeadLetterAddress() {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (addressSettings != null && addressSettings.getDeadLetterAddress() != null) {
                String string = addressSettings.getDeadLetterAddress().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getExpiryAddress() {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (addressSettings != null && addressSettings.getExpiryAddress() != null) {
                String string = addressSettings.getExpiryAddress().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public Map<String, Object>[] listScheduledMessages() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            List<MessageReference> refs = this.queue.getScheduledMessages();
            Map<String, Object>[] mapArray = this.convertMessagesToMaps(refs);
            return mapArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listScheduledMessagesAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listScheduledMessages());
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    private Map<String, Object>[] convertMessagesToMaps(List<MessageReference> refs) throws ActiveMQException {
        Map[] messages = new Map[refs.size()];
        int i = 0;
        for (MessageReference ref : refs) {
            ServerMessage message = ref.getMessage();
            messages[i++] = message.toMap();
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>[]> listDeliveringMessages() throws ActiveMQException {
        this.checkStarted();
        this.clearIO();
        try {
            Map<String, List<MessageReference>> msgs = this.queue.getDeliveringMessages();
            HashMap<String, Map<String, Object>[]> msgRet = new HashMap<String, Map<String, Object>[]>();
            for (Map.Entry<String, List<MessageReference>> entry : msgs.entrySet()) {
                msgRet.put(entry.getKey(), this.convertMessagesToMaps(entry.getValue()));
            }
            HashMap<String, Map<String, Object>[]> hashMap = msgRet;
            return hashMap;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listDeliveringMessagesAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listDeliveringMessages());
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * Exception decompiling
     */
    public Map<String, Object>[] listMessages(String filterStr) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String listMessagesAsJSON(String filter) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listMessages(filter));
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * Loose catch block
     */
    protected Map<String, Object>[] getFirstMessage() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            ArrayList<Map> messages = new ArrayList<Map>();
            this.queue.flushExecutor();
            try (LinkedListIterator<MessageReference> iterator = this.queue.totalIterator();){
                if (iterator.hasNext()) {
                    MessageReference ref = (MessageReference)iterator.next();
                    ServerMessage message = ref.getMessage();
                    messages.add(message.toMap());
                }
                Map[] mapArray = messages.toArray(new Map[1]);
                return mapArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getFirstMessageAsJSON() throws Exception {
        return QueueControlImpl.toJSON(this.getFirstMessage());
    }

    public Long getFirstMessageTimestamp() throws Exception {
        Map<String, Object>[] _message = this.getFirstMessage();
        if (_message == null || _message.length == 0 || _message[0] == null) {
            return null;
        }
        Map<String, Object> message = _message[0];
        if (!message.containsKey("timestamp")) {
            return null;
        }
        return (Long)message.get("timestamp");
    }

    public Long getFirstMessageAge() throws Exception {
        Long firstMessageTimestamp = this.getFirstMessageTimestamp();
        if (firstMessageTimestamp == null) {
            return null;
        }
        long now = new Date().getTime();
        return now - firstMessageTimestamp;
    }

    /*
     * Loose catch block
     */
    public long countMessages(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            if (filter == null) {
                long l = this.getMessageCount();
                return l;
            }
            try (LinkedListIterator<MessageReference> iterator = this.queue.totalIterator();){
                int count = 0;
                while (iterator.hasNext()) {
                    MessageReference ref = (MessageReference)iterator.next();
                    if (!filter.match(ref.getMessage())) continue;
                    ++count;
                }
                long l = count;
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean removeMessage(long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.deleteReference(messageID);
            return bl;
        }
        catch (ActiveMQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public int removeMessages(String filterStr) throws Exception {
        return this.removeMessages(500, filterStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMessages(int flushLimit, String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.deleteMatchingReferences(flushLimit, filter);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expireMessage(long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.expireReference(messageID);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int expireMessages(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.expireReferences(filter);
            return n;
        }
        catch (ActiveMQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryMessage(final long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter singleMessageFilter = new Filter(){

                @Override
                public boolean match(ServerMessage message) {
                    return message.getMessageID() == messageID;
                }

                @Override
                public SimpleString getFilterString() {
                    return new SimpleString("custom filter for MESSAGEID= messageID");
                }
            };
            boolean bl = this.queue.retryMessages(singleMessageFilter) > 0;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int retryMessages() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.retryMessages(null);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean moveMessage(long messageID, String otherQueueName) throws Exception {
        return this.moveMessage(messageID, otherQueueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMessage(long messageID, String otherQueueName, boolean rejectDuplicates) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Binding binding = this.postOffice.getBinding(new SimpleString(otherQueueName));
            if (binding == null) {
                throw ActiveMQMessageBundle.BUNDLE.noQueueFound(otherQueueName);
            }
            boolean bl = this.queue.moveReference(messageID, binding.getAddress(), rejectDuplicates);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int moveMessages(String filterStr, String otherQueueName) throws Exception {
        return this.moveMessages(filterStr, otherQueueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveMessages(int flushLimit, String filterStr, String otherQueueName, boolean rejectDuplicates) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            int retValue;
            Filter filter = FilterImpl.createFilter(filterStr);
            Binding binding = this.postOffice.getBinding(new SimpleString(otherQueueName));
            if (binding == null) {
                throw ActiveMQMessageBundle.BUNDLE.noQueueFound(otherQueueName);
            }
            int n = retValue = this.queue.moveReferences(flushLimit, filter, binding.getAddress(), rejectDuplicates);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int moveMessages(String filterStr, String otherQueueName, boolean rejectDuplicates) throws Exception {
        return this.moveMessages(500, filterStr, otherQueueName, rejectDuplicates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessagesToDeadLetterAddress(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.sendMessagesToDeadLetterAddress(filter);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String sendMessage(Map<String, String> headers, int type, String body, String userID, boolean durable, final String user, final String password) throws Exception {
        this.securityStore.check(this.queue.getAddress(), CheckType.SEND, new SecurityAuth(){

            @Override
            public String getUsername() {
                return user;
            }

            @Override
            public String getPassword() {
                return password;
            }

            @Override
            public RemotingConnection getRemotingConnection() {
                return null;
            }
        });
        ServerMessageImpl message = new ServerMessageImpl(this.storageManager.generateID(), 50);
        for (String header : headers.keySet()) {
            message.putStringProperty(new SimpleString(header), new SimpleString(headers.get(header)));
        }
        message.setType((byte)type);
        message.setDurable(durable);
        message.setTimestamp(System.currentTimeMillis());
        message.setUserID(new UUID(1, UUID.stringToBytes((String)userID)));
        if (body != null) {
            message.getBodyBuffer().writeBytes(Base64.decode((String)body));
        }
        message.setAddress(this.queue.getAddress());
        this.postOffice.route(message, null, true);
        return "" + message.getMessageID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.sendMessageToDeadLetterAddress(messageID);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeMessagesPriority(String filterStr, int newPriority) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            if (newPriority < 0 || newPriority > 9) {
                throw ActiveMQMessageBundle.BUNDLE.invalidNewPriority(newPriority);
            }
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.changeReferencesPriority(filter, (byte)newPriority);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeMessagePriority(long messageID, int newPriority) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            if (newPriority < 0 || newPriority > 9) {
                throw ActiveMQMessageBundle.BUNDLE.invalidNewPriority(newPriority);
            }
            boolean bl = this.queue.changeReferencePriority(messageID, (byte)newPriority);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listMessageCounter() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterInfo.toJSon(this.counter);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetMessageCounter() {
        this.checkStarted();
        this.clearIO();
        try {
            this.counter.resetCounter();
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listMessageCounterAsHTML() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterAsHTML(new MessageCounter[]{this.counter});
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listMessageCounterHistory() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterHistory(this.counter);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listMessageCounterHistoryAsHTML() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterHistoryAsHTML(new MessageCounter[]{this.counter});
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void pause() {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.pause();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resume() {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resume();
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPaused() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isPaused();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * Exception decompiling
     */
    public CompositeData[] browse(String filterStr) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void flushExecutor() {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConsumersAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Collection<Consumer> consumers = this.queue.getConsumers();
            JSONArray jsonArray = new JSONArray();
            for (Consumer consumer : consumers) {
                if (!(consumer instanceof ServerConsumer)) continue;
                ServerConsumer serverConsumer = (ServerConsumer)consumer;
                JSONObject obj = new JSONObject();
                obj.put("consumerID", serverConsumer.getID());
                obj.put("connectionID", (Object)serverConsumer.getConnectionID().toString());
                obj.put("sessionID", (Object)serverConsumer.getSessionID());
                obj.put("browseOnly", serverConsumer.isBrowseOnly());
                obj.put("creationTime", serverConsumer.getCreationTime());
                jsonArray.put((Object)obj);
            }
            String string = jsonArray.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(QueueControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(QueueControl.class);
    }

    public void resetMessagesAdded() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resetMessagesAdded();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetMessagesAcknowledged() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resetMessagesAcknowledged();
        }
        finally {
            this.blockOnIO();
        }
    }

    private void checkStarted() {
        if (!this.postOffice.isStarted()) {
            throw new IllegalStateException("Broker is not started. Queue can not be managed yet");
        }
    }
}

