/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.deployers.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.Validators;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.config.storage.FileStorageConfiguration;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.uri.AcceptorTransportConfigurationParser;
import org.apache.activemq.artemis.uri.ConnectorTransportConfigurationParser;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;
import org.apache.activemq.artemis.utils.XMLConfigurationUtil;
import org.apache.activemq.artemis.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FileConfigurationParser
extends XMLConfigurationUtil {
    public static final String SECURITY_ELEMENT_NAME = "security-setting";
    public static final String SECURITY_PLUGIN_ELEMENT_NAME = "security-setting-plugin";
    private static final String PERMISSION_ELEMENT_NAME = "permission";
    private static final String SETTING_ELEMENT_NAME = "setting";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String ROLES_ATTR_NAME = "roles";
    private static final String NAME_ATTR_NAME = "name";
    private static final String VALUE_ATTR_NAME = "value";
    static final String CREATEDURABLEQUEUE_NAME = "createDurableQueue";
    private static final String DELETEDURABLEQUEUE_NAME = "deleteDurableQueue";
    private static final String CREATE_NON_DURABLE_QUEUE_NAME = "createNonDurableQueue";
    private static final String DELETE_NON_DURABLE_QUEUE_NAME = "deleteNonDurableQueue";
    private static final String CREATETEMPQUEUE_NAME = "createTempQueue";
    private static final String DELETETEMPQUEUE_NAME = "deleteTempQueue";
    private static final String SEND_NAME = "send";
    private static final String CONSUME_NAME = "consume";
    private static final String MANAGE_NAME = "manage";
    private static final String DEAD_LETTER_ADDRESS_NODE_NAME = "dead-letter-address";
    private static final String EXPIRY_ADDRESS_NODE_NAME = "expiry-address";
    private static final String EXPIRY_DELAY_NODE_NAME = "expiry-delay";
    private static final String REDELIVERY_DELAY_NODE_NAME = "redelivery-delay";
    private static final String REDELIVERY_DELAY_MULTIPLIER_NODE_NAME = "redelivery-delay-multiplier";
    private static final String MAX_REDELIVERY_DELAY_NODE_NAME = "max-redelivery-delay";
    private static final String MAX_DELIVERY_ATTEMPTS = "max-delivery-attempts";
    private static final String MAX_SIZE_BYTES_NODE_NAME = "max-size-bytes";
    private static final String ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME = "address-full-policy";
    private static final String PAGE_SIZE_BYTES_NODE_NAME = "page-size-bytes";
    private static final String PAGE_MAX_CACHE_SIZE_NODE_NAME = "page-max-cache-size";
    private static final String MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME = "message-counter-history-day-limit";
    private static final String LVQ_NODE_NAME = "last-value-queue";
    private static final String REDISTRIBUTION_DELAY_NODE_NAME = "redistribution-delay";
    private static final String SEND_TO_DLA_ON_NO_ROUTE = "send-to-dla-on-no-route";
    private static final String SLOW_CONSUMER_THRESHOLD_NODE_NAME = "slow-consumer-threshold";
    private static final String SLOW_CONSUMER_CHECK_PERIOD_NODE_NAME = "slow-consumer-check-period";
    private static final String SLOW_CONSUMER_POLICY_NODE_NAME = "slow-consumer-policy";
    private static final String AUTO_CREATE_JMS_QUEUES = "auto-create-jms-queues";
    private static final String AUTO_DELETE_JMS_QUEUES = "auto-delete-jms-queues";
    private static final String AUTO_CREATE_JMS_TOPICS = "auto-create-jms-topics";
    private static final String AUTO_DELETE_JMS_TOPICS = "auto-delete-jms-topics";
    private static final String MANAGEMENT_BROWSE_PAGE_SIZE = "management-browse-page-size";
    private static final String MAX_CONNECTIONS_NODE_NAME = "max-connections";
    private static final String MAX_QUEUES_NODE_NAME = "max-queues";
    private boolean validateAIO = false;
    private static final ArrayList<String> POLICY_LIST = new ArrayList();
    private static final ArrayList<String> HA_LIST;
    private static final ArrayList<String> STORE_TYPE_LIST;

    public boolean isValidateAIO() {
        return this.validateAIO;
    }

    public void setValidateAIO(boolean validateAIO) {
        this.validateAIO = validateAIO;
    }

    public Configuration parseMainConfig(InputStream input) throws Exception {
        InputStreamReader reader = new InputStreamReader(input);
        String xml = XMLUtil.readerToString((Reader)reader);
        xml = XMLUtil.replaceSystemProps((String)xml);
        Element e = XMLUtil.stringToElement((String)xml);
        ConfigurationImpl config = new ConfigurationImpl();
        this.parseMainConfig(e, config);
        return config;
    }

    public void parseMainConfig(Element e, Configuration config) throws Exception {
        int i;
        NodeList incomingInterceptorNodes;
        NodeList storeTypeNodes;
        config.setName(FileConfigurationParser.getString(e, NAME_ATTR_NAME, config.getName(), Validators.NO_CHECK));
        NodeList haPolicyNodes = e.getElementsByTagName("ha-policy");
        if (haPolicyNodes.getLength() > 0) {
            this.parseHAPolicyConfiguration((Element)haPolicyNodes.item(0), config);
        }
        if (config.getHAPolicyConfiguration() == null) {
            config.setHAPolicyConfiguration(new LiveOnlyPolicyConfiguration());
        }
        if ((storeTypeNodes = e.getElementsByTagName("store")).getLength() > 0) {
            this.parseStoreConfiguration((Element)storeTypeNodes.item(0), config);
        }
        config.setResolveProtocols(FileConfigurationParser.getBoolean(e, "resolve-protocols", config.isResolveProtocols()));
        config.setPersistenceEnabled(FileConfigurationParser.getBoolean(e, "persistence-enabled", config.isPersistenceEnabled()));
        config.setPersistDeliveryCountBeforeDelivery(FileConfigurationParser.getBoolean(e, "persist-delivery-count-before-delivery", config.isPersistDeliveryCountBeforeDelivery()));
        config.setScheduledThreadPoolMaxSize(FileConfigurationParser.getInteger(e, "scheduled-thread-pool-max-size", config.getScheduledThreadPoolMaxSize(), Validators.GT_ZERO));
        config.setThreadPoolMaxSize(FileConfigurationParser.getInteger(e, "thread-pool-max-size", config.getThreadPoolMaxSize(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setSecurityEnabled(FileConfigurationParser.getBoolean(e, "security-enabled", config.isSecurityEnabled()));
        config.setGracefulShutdownEnabled(FileConfigurationParser.getBoolean(e, "graceful-shutdown-enabled", config.isGracefulShutdownEnabled()));
        config.setGracefulShutdownTimeout(FileConfigurationParser.getLong(e, "graceful-shutdown-timeout", config.getGracefulShutdownTimeout(), Validators.MINUS_ONE_OR_GE_ZERO));
        config.setJMXManagementEnabled(FileConfigurationParser.getBoolean(e, "jmx-management-enabled", config.isJMXManagementEnabled()));
        config.setJMXDomain(FileConfigurationParser.getString(e, "jmx-domain", config.getJMXDomain(), Validators.NOT_NULL_OR_EMPTY));
        config.setJMXUseBrokerName(FileConfigurationParser.getBoolean(e, "jmx-use-broker-name", config.isJMXUseBrokerName()));
        config.setSecurityInvalidationInterval(FileConfigurationParser.getLong(e, "security-invalidation-interval", config.getSecurityInvalidationInterval(), Validators.GT_ZERO));
        config.setConnectionTTLOverride(FileConfigurationParser.getLong(e, "connection-ttl-override", config.getConnectionTTLOverride(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setEnabledAsyncConnectionExecution(FileConfigurationParser.getBoolean(e, "async-connection-execution-enabled", config.isAsyncConnectionExecutionEnabled()));
        config.setTransactionTimeout(FileConfigurationParser.getLong(e, "transaction-timeout", config.getTransactionTimeout(), Validators.GT_ZERO));
        config.setTransactionTimeoutScanPeriod(FileConfigurationParser.getLong(e, "transaction-timeout-scan-period", config.getTransactionTimeoutScanPeriod(), Validators.GT_ZERO));
        config.setMessageExpiryScanPeriod(FileConfigurationParser.getLong(e, "message-expiry-scan-period", config.getMessageExpiryScanPeriod(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setMessageExpiryThreadPriority(FileConfigurationParser.getInteger(e, "message-expiry-thread-priority", config.getMessageExpiryThreadPriority(), Validators.THREAD_PRIORITY_RANGE));
        config.setIDCacheSize(FileConfigurationParser.getInteger(e, "id-cache-size", config.getIDCacheSize(), Validators.GT_ZERO));
        config.setPersistIDCache(FileConfigurationParser.getBoolean(e, "persist-id-cache", config.isPersistIDCache()));
        config.setManagementAddress(new SimpleString(FileConfigurationParser.getString(e, "management-address", config.getManagementAddress().toString(), Validators.NOT_NULL_OR_EMPTY)));
        config.setManagementNotificationAddress(new SimpleString(FileConfigurationParser.getString(e, "management-notification-address", config.getManagementNotificationAddress().toString(), Validators.NOT_NULL_OR_EMPTY)));
        config.setMaskPassword(FileConfigurationParser.getBoolean(e, "mask-password", false));
        config.setPasswordCodec(FileConfigurationParser.getString(e, "password-codec", DefaultSensitiveStringCodec.class.getName(), Validators.NOT_NULL_OR_EMPTY));
        String passwordText = FileConfigurationParser.getString(e, "cluster-password", null, Validators.NO_CHECK);
        boolean maskText = config.isMaskPassword();
        if (passwordText != null) {
            if (maskText) {
                SensitiveDataCodec codec = PasswordMaskingUtil.getCodec((String)config.getPasswordCodec());
                config.setClusterPassword((String)codec.decode((Object)passwordText));
            } else {
                config.setClusterPassword(passwordText);
            }
        }
        config.setClusterUser(FileConfigurationParser.getString(e, "cluster-user", config.getClusterUser(), Validators.NO_CHECK));
        NodeList interceptorNodes = e.getElementsByTagName("remoting-interceptors");
        ArrayList<String> incomingInterceptorList = new ArrayList<String>();
        if (interceptorNodes.getLength() > 0) {
            NodeList interceptors = interceptorNodes.item(0).getChildNodes();
            for (int i2 = 0; i2 < interceptors.getLength(); ++i2) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i2).getNodeName())) continue;
                String clazz = FileConfigurationParser.getTrimmedTextContent(interceptors.item(i2));
                incomingInterceptorList.add(clazz);
            }
        }
        if ((incomingInterceptorNodes = e.getElementsByTagName("remoting-incoming-interceptors")).getLength() > 0) {
            NodeList interceptors = incomingInterceptorNodes.item(0).getChildNodes();
            for (int i3 = 0; i3 < interceptors.getLength(); ++i3) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i3).getNodeName())) continue;
                String clazz = FileConfigurationParser.getTrimmedTextContent(interceptors.item(i3));
                incomingInterceptorList.add(clazz);
            }
        }
        config.setIncomingInterceptorClassNames(incomingInterceptorList);
        NodeList outgoingInterceptorNodes = e.getElementsByTagName("remoting-outgoing-interceptors");
        ArrayList<String> outgoingInterceptorList = new ArrayList<String>();
        if (outgoingInterceptorNodes.getLength() > 0) {
            NodeList interceptors = outgoingInterceptorNodes.item(0).getChildNodes();
            for (i = 0; i < interceptors.getLength(); ++i) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i).getNodeName())) continue;
                String clazz = interceptors.item(i).getTextContent();
                outgoingInterceptorList.add(clazz);
            }
        }
        config.setOutgoingInterceptorClassNames(outgoingInterceptorList);
        NodeList connectorNodes = e.getElementsByTagName("connector");
        for (i = 0; i < connectorNodes.getLength(); ++i) {
            Element connectorNode = (Element)connectorNodes.item(i);
            TransportConfiguration connectorConfig = this.parseConnectorTransportConfiguration(connectorNode, config);
            if (connectorConfig.getName() == null) {
                ActiveMQServerLogger.LOGGER.connectorWithNoName();
                continue;
            }
            if (config.getConnectorConfigurations().containsKey(connectorConfig.getName())) {
                ActiveMQServerLogger.LOGGER.connectorAlreadyDeployed(connectorConfig.getName());
                continue;
            }
            config.getConnectorConfigurations().put(connectorConfig.getName(), connectorConfig);
        }
        NodeList acceptorNodes = e.getElementsByTagName("acceptor");
        for (int i4 = 0; i4 < acceptorNodes.getLength(); ++i4) {
            Element acceptorNode = (Element)acceptorNodes.item(i4);
            TransportConfiguration acceptorConfig = this.parseAcceptorTransportConfiguration(acceptorNode, config);
            config.getAcceptorConfigurations().add(acceptorConfig);
        }
        NodeList bgNodes = e.getElementsByTagName("broadcast-group");
        for (int i5 = 0; i5 < bgNodes.getLength(); ++i5) {
            Element bgNode = (Element)bgNodes.item(i5);
            this.parseBroadcastGroupConfiguration(bgNode, config);
        }
        NodeList dgNodes = e.getElementsByTagName("discovery-group");
        for (int i6 = 0; i6 < dgNodes.getLength(); ++i6) {
            Element dgNode = (Element)dgNodes.item(i6);
            this.parseDiscoveryGroupConfiguration(dgNode, config);
        }
        NodeList brNodes = e.getElementsByTagName("bridge");
        for (int i7 = 0; i7 < brNodes.getLength(); ++i7) {
            Element mfNode = (Element)brNodes.item(i7);
            this.parseBridgeConfiguration(mfNode, config);
        }
        NodeList gaNodes = e.getElementsByTagName("grouping-handler");
        for (int i8 = 0; i8 < gaNodes.getLength(); ++i8) {
            Element gaNode = (Element)gaNodes.item(i8);
            this.parseGroupingHandlerConfiguration(gaNode, config);
        }
        NodeList ccNodes = e.getElementsByTagName("cluster-connection");
        for (int i9 = 0; i9 < ccNodes.getLength(); ++i9) {
            Element ccNode = (Element)ccNodes.item(i9);
            this.parseClusterConnectionConfiguration(ccNode, config);
        }
        NodeList ccNodesURI = e.getElementsByTagName("cluster-connection-uri");
        for (int i10 = 0; i10 < ccNodesURI.getLength(); ++i10) {
            Element ccNode = (Element)ccNodesURI.item(i10);
            this.parseClusterConnectionConfigurationURI(ccNode, config);
        }
        NodeList dvNodes = e.getElementsByTagName("divert");
        for (int i11 = 0; i11 < dvNodes.getLength(); ++i11) {
            Element dvNode = (Element)dvNodes.item(i11);
            this.parseDivertConfiguration(dvNode, config);
        }
        config.setLargeMessagesDirectory(FileConfigurationParser.getString(e, "large-messages-directory", config.getLargeMessagesDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setBindingsDirectory(FileConfigurationParser.getString(e, "bindings-directory", config.getBindingsDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setCreateBindingsDir(FileConfigurationParser.getBoolean(e, "create-bindings-dir", config.isCreateBindingsDir()));
        config.setJournalDirectory(FileConfigurationParser.getString(e, "journal-directory", config.getJournalDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setPageMaxConcurrentIO(FileConfigurationParser.getInteger(e, "page-max-concurrent-io", config.getPageMaxConcurrentIO(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setPagingDirectory(FileConfigurationParser.getString(e, "paging-directory", config.getPagingDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setCreateJournalDir(FileConfigurationParser.getBoolean(e, "create-journal-dir", config.isCreateJournalDir()));
        String s = FileConfigurationParser.getString(e, "journal-type", config.getJournalType().toString(), Validators.JOURNAL_TYPE);
        if (s.equals(JournalType.NIO.toString())) {
            config.setJournalType(JournalType.NIO);
        } else if (s.equals(JournalType.ASYNCIO.toString())) {
            boolean supportsAIO = AIOSequentialFileFactory.isSupported();
            if (supportsAIO) {
                config.setJournalType(JournalType.ASYNCIO);
            } else {
                if (this.validateAIO) {
                    ActiveMQServerLogger.LOGGER.AIONotFound();
                }
                config.setJournalType(JournalType.NIO);
            }
        }
        config.setJournalSyncTransactional(FileConfigurationParser.getBoolean(e, "journal-sync-transactional", config.isJournalSyncTransactional()));
        config.setJournalSyncNonTransactional(FileConfigurationParser.getBoolean(e, "journal-sync-non-transactional", config.isJournalSyncNonTransactional()));
        config.setJournalFileSize(FileConfigurationParser.getInteger(e, "journal-file-size", config.getJournalFileSize(), Validators.GT_ZERO));
        int journalBufferTimeout = FileConfigurationParser.getInteger(e, "journal-buffer-timeout", config.getJournalType() == JournalType.ASYNCIO ? 500000 : 3333333, Validators.GT_ZERO);
        int journalBufferSize = FileConfigurationParser.getInteger(e, "journal-buffer-size", config.getJournalType() == JournalType.ASYNCIO ? 501760 : 501760, Validators.GT_ZERO);
        int journalMaxIO = FileConfigurationParser.getInteger(e, "journal-max-io", config.getJournalType() == JournalType.ASYNCIO ? ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio() : ActiveMQDefaultConfiguration.getDefaultJournalMaxIoNio(), Validators.GT_ZERO);
        if (config.getJournalType() == JournalType.ASYNCIO) {
            config.setJournalBufferTimeout_AIO(journalBufferTimeout);
            config.setJournalBufferSize_AIO(journalBufferSize);
            config.setJournalMaxIO_AIO(journalMaxIO);
        } else {
            config.setJournalBufferTimeout_NIO(journalBufferTimeout);
            config.setJournalBufferSize_NIO(journalBufferSize);
            config.setJournalMaxIO_NIO(journalMaxIO);
        }
        config.setJournalMinFiles(FileConfigurationParser.getInteger(e, "journal-min-files", config.getJournalMinFiles(), Validators.GT_ZERO));
        config.setJournalPoolFiles(FileConfigurationParser.getInteger(e, "journal-pool-files", config.getJournalPoolFiles(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setJournalCompactMinFiles(FileConfigurationParser.getInteger(e, "journal-compact-min-files", config.getJournalCompactMinFiles(), Validators.GE_ZERO));
        config.setJournalCompactPercentage(FileConfigurationParser.getInteger(e, "journal-compact-percentage", config.getJournalCompactPercentage(), Validators.PERCENTAGE));
        config.setLogJournalWriteRate(FileConfigurationParser.getBoolean(e, "log-journal-write-rate", ActiveMQDefaultConfiguration.isDefaultJournalLogWriteRate()));
        config.setJournalPerfBlastPages(FileConfigurationParser.getInteger(e, "perf-blast-pages", ActiveMQDefaultConfiguration.getDefaultJournalPerfBlastPages(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setRunSyncSpeedTest(FileConfigurationParser.getBoolean(e, "run-sync-speed-test", config.isRunSyncSpeedTest()));
        config.setWildcardRoutingEnabled(FileConfigurationParser.getBoolean(e, "wild-card-routing-enabled", config.isWildcardRoutingEnabled()));
        config.setMessageCounterEnabled(FileConfigurationParser.getBoolean(e, "message-counter-enabled", config.isMessageCounterEnabled()));
        config.setMessageCounterSamplePeriod(FileConfigurationParser.getLong(e, "message-counter-sample-period", config.getMessageCounterSamplePeriod(), Validators.GT_ZERO));
        config.setMessageCounterMaxDayHistory(FileConfigurationParser.getInteger(e, "message-counter-max-day-history", config.getMessageCounterMaxDayHistory(), Validators.GT_ZERO));
        config.setServerDumpInterval(FileConfigurationParser.getLong(e, "server-dump-interval", config.getServerDumpInterval(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setMemoryWarningThreshold(FileConfigurationParser.getInteger(e, "memory-warning-threshold", config.getMemoryWarningThreshold(), Validators.PERCENTAGE));
        config.setMemoryMeasureInterval(FileConfigurationParser.getLong(e, "memory-measure-interval", config.getMemoryMeasureInterval(), Validators.MINUS_ONE_OR_GT_ZERO));
        this.parseAddressSettings(e, config);
        this.parseResourceLimits(e, config);
        this.parseQueues(e, config);
        this.parseSecurity(e, config);
        NodeList connectorServiceConfigs = e.getElementsByTagName("connector-service");
        ArrayList<ConnectorServiceConfiguration> configs = new ArrayList<ConnectorServiceConfiguration>();
        for (int i12 = 0; i12 < connectorServiceConfigs.getLength(); ++i12) {
            Element node = (Element)connectorServiceConfigs.item(i12);
            configs.add(this.parseConnectorService(node));
        }
        config.setConnectorServiceConfigurations(configs);
    }

    private void parseSecurity(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("security-settings");
        if (elements.getLength() != 0) {
            Object securityItem;
            int i;
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName(SECURITY_ELEMENT_NAME);
            for (i = 0; i < list.getLength(); ++i) {
                securityItem = this.parseSecurityRoles(list.item(i));
                config.putSecurityRoles((String)securityItem.getA(), (Set)securityItem.getB());
            }
            list = node.getElementsByTagName(SECURITY_PLUGIN_ELEMENT_NAME);
            for (i = 0; i < list.getLength(); ++i) {
                securityItem = this.parseSecuritySettingPlugins(list.item(i));
                config.addSecuritySettingPlugin(((SecuritySettingPlugin)securityItem.getA()).init((Map)securityItem.getB()));
            }
        }
    }

    private void parseQueues(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("queues");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("queue");
            for (int i = 0; i < list.getLength(); ++i) {
                CoreQueueConfiguration queueConfig = this.parseQueueConfiguration(list.item(i));
                config.getQueueConfigurations().add(queueConfig);
            }
        }
    }

    private void parseAddressSettings(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("address-settings");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("address-setting");
            for (int i = 0; i < list.getLength(); ++i) {
                Pair<String, AddressSettings> addressSettings = this.parseAddressSettings(list.item(i));
                config.getAddressesSettings().put((String)addressSettings.getA(), (AddressSettings)addressSettings.getB());
            }
        }
    }

    private void parseResourceLimits(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("resource-limit-settings");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("resource-limit-setting");
            for (int i = 0; i < list.getLength(); ++i) {
                config.addResourceLimitSettings(this.parseResourceLimitSettings(list.item(i)));
            }
        }
    }

    protected Pair<String, Set<Role>> parseSecurityRoles(Node node) {
        String match = node.getAttributes().getNamedItem("match").getNodeValue();
        HashSet<Role> securityRoles = new HashSet<Role>();
        Pair securityMatch = new Pair((Object)match, securityRoles);
        ArrayList<String> send = new ArrayList<String>();
        ArrayList<String> consume = new ArrayList<String>();
        ArrayList<String> createDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteDurableQueue = new ArrayList<String>();
        ArrayList<String> createNonDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
        ArrayList<String> manageRoles = new ArrayList<String>();
        ArrayList<String> allRoles = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String[] roles;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (!PERMISSION_ELEMENT_NAME.equalsIgnoreCase(name)) continue;
            String type = FileConfigurationParser.getAttributeValue(child, TYPE_ATTR_NAME);
            String roleString = FileConfigurationParser.getAttributeValue(child, ROLES_ATTR_NAME);
            for (String role : roles = roleString.split(",")) {
                if (SEND_NAME.equals(type)) {
                    send.add(role.trim());
                } else if (CONSUME_NAME.equals(type)) {
                    consume.add(role.trim());
                } else if (CREATEDURABLEQUEUE_NAME.equals(type)) {
                    createDurableQueue.add(role.trim());
                } else if (DELETEDURABLEQUEUE_NAME.equals(type)) {
                    deleteDurableQueue.add(role.trim());
                } else if (CREATE_NON_DURABLE_QUEUE_NAME.equals(type)) {
                    createNonDurableQueue.add(role.trim());
                } else if (DELETE_NON_DURABLE_QUEUE_NAME.equals(type)) {
                    deleteNonDurableQueue.add(role.trim());
                } else if (CREATETEMPQUEUE_NAME.equals(type)) {
                    createNonDurableQueue.add(role.trim());
                } else if (DELETETEMPQUEUE_NAME.equals(type)) {
                    deleteNonDurableQueue.add(role.trim());
                } else if (MANAGE_NAME.equals(type)) {
                    manageRoles.add(role.trim());
                } else {
                    ActiveMQServerLogger.LOGGER.rolePermissionConfigurationError(type);
                }
                if (allRoles.contains(role.trim())) continue;
                allRoles.add(role.trim());
            }
        }
        for (String role : allRoles) {
            securityRoles.add(new Role(role, send.contains(role), consume.contains(role), createDurableQueue.contains(role), deleteDurableQueue.contains(role), createNonDurableQueue.contains(role), deleteNonDurableQueue.contains(role), manageRoles.contains(role)));
        }
        return securityMatch;
    }

    private Pair<SecuritySettingPlugin, Map<String, String>> parseSecuritySettingPlugins(Node item) {
        final String clazz = item.getAttributes().getNamedItem("class-name").getNodeValue();
        HashMap<String, String> settings = new HashMap<String, String>();
        NodeList children = item.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            String nodeName = child.getNodeName();
            if (!SETTING_ELEMENT_NAME.equalsIgnoreCase(nodeName)) continue;
            String settingName = FileConfigurationParser.getAttributeValue(child, NAME_ATTR_NAME);
            String settingValue = FileConfigurationParser.getAttributeValue(child, VALUE_ATTR_NAME);
            settings.put(settingName, settingValue);
        }
        SecuritySettingPlugin securitySettingPlugin = AccessController.doPrivileged(new PrivilegedAction<SecuritySettingPlugin>(){

            @Override
            public SecuritySettingPlugin run() {
                return (SecuritySettingPlugin)ClassloadingUtil.newInstanceFromClassLoader((String)clazz);
            }
        });
        return new Pair((Object)securitySettingPlugin, settings);
    }

    protected Pair<String, AddressSettings> parseAddressSettings(Node node) {
        String match = FileConfigurationParser.getAttributeValue(node, "match");
        NodeList children = node.getChildNodes();
        AddressSettings addressSettings = new AddressSettings();
        Pair setting = new Pair((Object)match, (Object)addressSettings);
        for (int i = 0; i < children.getLength(); ++i) {
            Object policy;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (DEAD_LETTER_ADDRESS_NODE_NAME.equalsIgnoreCase(name)) {
                SimpleString queueName = new SimpleString(FileConfigurationParser.getTrimmedTextContent(child));
                addressSettings.setDeadLetterAddress(queueName);
                continue;
            }
            if (EXPIRY_ADDRESS_NODE_NAME.equalsIgnoreCase(name)) {
                SimpleString queueName = new SimpleString(FileConfigurationParser.getTrimmedTextContent(child));
                addressSettings.setExpiryAddress(queueName);
                continue;
            }
            if (EXPIRY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setExpiryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (REDELIVERY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setRedeliveryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (REDELIVERY_DELAY_MULTIPLIER_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setRedeliveryMultiplier(XMLUtil.parseDouble((Node)child));
                continue;
            }
            if (MAX_REDELIVERY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxRedeliveryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (MAX_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxSizeBytes(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (PAGE_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPageSizeBytes(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (PAGE_MAX_CACHE_SIZE_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPageCacheMaxSize(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMessageCounterHistoryDayLimit(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME.equalsIgnoreCase(name)) {
                String value = FileConfigurationParser.getTrimmedTextContent(child);
                Validators.ADDRESS_FULL_MESSAGE_POLICY_TYPE.validate(ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME, value);
                policy = Enum.valueOf(AddressFullMessagePolicy.class, value);
                addressSettings.setAddressFullMessagePolicy((AddressFullMessagePolicy)policy);
                continue;
            }
            if (LVQ_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setLastValueQueue(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (MAX_DELIVERY_ATTEMPTS.equalsIgnoreCase(name)) {
                addressSettings.setMaxDeliveryAttempts(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (REDISTRIBUTION_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setRedistributionDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (SEND_TO_DLA_ON_NO_ROUTE.equalsIgnoreCase(name)) {
                addressSettings.setSendToDLAOnNoRoute(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (SLOW_CONSUMER_THRESHOLD_NODE_NAME.equalsIgnoreCase(name)) {
                long slowConsumerThreshold = XMLUtil.parseLong((Node)child);
                Validators.MINUS_ONE_OR_GT_ZERO.validate(SLOW_CONSUMER_THRESHOLD_NODE_NAME, slowConsumerThreshold);
                addressSettings.setSlowConsumerThreshold(slowConsumerThreshold);
                continue;
            }
            if (SLOW_CONSUMER_CHECK_PERIOD_NODE_NAME.equalsIgnoreCase(name)) {
                long slowConsumerCheckPeriod = XMLUtil.parseLong((Node)child);
                Validators.GT_ZERO.validate(SLOW_CONSUMER_CHECK_PERIOD_NODE_NAME, slowConsumerCheckPeriod);
                addressSettings.setSlowConsumerCheckPeriod(slowConsumerCheckPeriod);
                continue;
            }
            if (SLOW_CONSUMER_POLICY_NODE_NAME.equalsIgnoreCase(name)) {
                String value = FileConfigurationParser.getTrimmedTextContent(child);
                Validators.SLOW_CONSUMER_POLICY_TYPE.validate(SLOW_CONSUMER_POLICY_NODE_NAME, value);
                policy = Enum.valueOf(SlowConsumerPolicy.class, value);
                addressSettings.setSlowConsumerPolicy((SlowConsumerPolicy)((Object)policy));
                continue;
            }
            if (AUTO_CREATE_JMS_QUEUES.equalsIgnoreCase(name)) {
                addressSettings.setAutoCreateJmsQueues(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_DELETE_JMS_QUEUES.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteJmsQueues(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_CREATE_JMS_TOPICS.equalsIgnoreCase(name)) {
                addressSettings.setAutoCreateJmsTopics(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_DELETE_JMS_TOPICS.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteJmsTopics(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (!MANAGEMENT_BROWSE_PAGE_SIZE.equalsIgnoreCase(name)) continue;
            addressSettings.setManagementBrowsePageSize(XMLUtil.parseInt((Node)child));
        }
        return setting;
    }

    protected ResourceLimitSettings parseResourceLimitSettings(Node node) {
        ResourceLimitSettings resourceLimitSettings = new ResourceLimitSettings();
        resourceLimitSettings.setMatch(SimpleString.toSimpleString((String)FileConfigurationParser.getAttributeValue(node, "match")));
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (MAX_CONNECTIONS_NODE_NAME.equalsIgnoreCase(name)) {
                resourceLimitSettings.setMaxConnections(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (!MAX_QUEUES_NODE_NAME.equalsIgnoreCase(name)) continue;
            resourceLimitSettings.setMaxQueues(XMLUtil.parseInt((Node)child));
        }
        return resourceLimitSettings;
    }

    protected CoreQueueConfiguration parseQueueConfiguration(Node node) {
        String name = FileConfigurationParser.getAttributeValue(node, NAME_ATTR_NAME);
        String address = null;
        String filterString = null;
        boolean durable = true;
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("address")) {
                address = FileConfigurationParser.getTrimmedTextContent(child);
                continue;
            }
            if (child.getNodeName().equals("filter")) {
                filterString = FileConfigurationParser.getAttributeValue(child, "string");
                continue;
            }
            if (!child.getNodeName().equals("durable")) continue;
            durable = XMLUtil.parseBoolean((Node)child);
        }
        return new CoreQueueConfiguration().setAddress(address).setName(name).setFilterString(filterString).setDurable(durable);
    }

    private TransportConfiguration parseAcceptorTransportConfiguration(Element e, Configuration mainConfig) throws Exception {
        Node nameNode = e.getAttributes().getNamedItem(NAME_ATTR_NAME);
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String uri = e.getChildNodes().item(0).getNodeValue();
        AcceptorTransportConfigurationParser parser = new AcceptorTransportConfigurationParser();
        List configurations = (List)parser.newObject(parser.expandURI(uri), name);
        Map params = ((TransportConfiguration)configurations.get(0)).getParams();
        if (mainConfig.isMaskPassword()) {
            params.put(ActiveMQDefaultConfiguration.getPropMaskPassword(), mainConfig.isMaskPassword());
            if (mainConfig.getPasswordCodec() != null) {
                params.put(ActiveMQDefaultConfiguration.getPropPasswordCodec(), mainConfig.getPasswordCodec());
            }
        }
        return (TransportConfiguration)configurations.get(0);
    }

    private TransportConfiguration parseConnectorTransportConfiguration(Element e, Configuration mainConfig) throws Exception {
        Node nameNode = e.getAttributes().getNamedItem(NAME_ATTR_NAME);
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String uri = e.getChildNodes().item(0).getNodeValue();
        ConnectorTransportConfigurationParser parser = new ConnectorTransportConfigurationParser();
        List configurations = (List)parser.newObject(parser.expandURI(uri), (Object)name);
        Map params = ((TransportConfiguration)configurations.get(0)).getParams();
        if (mainConfig.isMaskPassword()) {
            params.put(ActiveMQDefaultConfiguration.getPropMaskPassword(), mainConfig.isMaskPassword());
            if (mainConfig.getPasswordCodec() != null) {
                params.put(ActiveMQDefaultConfiguration.getPropPasswordCodec(), mainConfig.getPasswordCodec());
            }
        }
        return (TransportConfiguration)configurations.get(0);
    }

    private void parseStoreConfiguration(Element e, Configuration mainConfig) {
        for (String storeType : STORE_TYPE_LIST) {
            NodeList storeNodeList = e.getElementsByTagName(storeType);
            if (storeNodeList.getLength() <= 0) continue;
            Element storeNode = (Element)storeNodeList.item(0);
            if (storeNode.getTagName().equals("database-store")) {
                mainConfig.setStoreConfiguration(this.createDatabaseStoreConfig(storeNode));
                continue;
            }
            if (!storeNode.getTagName().equals("file-store")) continue;
            mainConfig.setStoreConfiguration(this.createFileStoreConfig(storeNode));
        }
    }

    private void parseHAPolicyConfiguration(Element e, Configuration mainConfig) {
        for (String haType : HA_LIST) {
            Element colocatedNode;
            NodeList colocatedNodeList;
            Element slaveNode;
            NodeList slaveNodeList;
            Element masterNode;
            NodeList masterNodeList;
            NodeList haNodeList = e.getElementsByTagName(haType);
            if (haNodeList.getLength() <= 0) continue;
            Element haNode = (Element)haNodeList.item(0);
            if (haNode.getTagName().equals("replication")) {
                masterNodeList = e.getElementsByTagName("master");
                if (masterNodeList.getLength() > 0) {
                    masterNode = (Element)masterNodeList.item(0);
                    mainConfig.setHAPolicyConfiguration(this.createReplicatedHaPolicy(masterNode));
                }
                if ((slaveNodeList = e.getElementsByTagName("slave")).getLength() > 0) {
                    slaveNode = (Element)slaveNodeList.item(0);
                    mainConfig.setHAPolicyConfiguration(this.createReplicaHaPolicy(slaveNode));
                }
                if ((colocatedNodeList = e.getElementsByTagName("colocated")).getLength() <= 0) continue;
                colocatedNode = (Element)colocatedNodeList.item(0);
                mainConfig.setHAPolicyConfiguration(this.createColocatedHaPolicy(colocatedNode, true));
                continue;
            }
            if (haNode.getTagName().equals("shared-store")) {
                masterNodeList = e.getElementsByTagName("master");
                if (masterNodeList.getLength() > 0) {
                    masterNode = (Element)masterNodeList.item(0);
                    mainConfig.setHAPolicyConfiguration(this.createSharedStoreMasterHaPolicy(masterNode));
                }
                if ((slaveNodeList = e.getElementsByTagName("slave")).getLength() > 0) {
                    slaveNode = (Element)slaveNodeList.item(0);
                    mainConfig.setHAPolicyConfiguration(this.createSharedStoreSlaveHaPolicy(slaveNode));
                }
                if ((colocatedNodeList = e.getElementsByTagName("colocated")).getLength() <= 0) continue;
                colocatedNode = (Element)colocatedNodeList.item(0);
                mainConfig.setHAPolicyConfiguration(this.createColocatedHaPolicy(colocatedNode, false));
                continue;
            }
            if (!haNode.getTagName().equals("live-only")) continue;
            NodeList noneNodeList = e.getElementsByTagName("live-only");
            Element noneNode = (Element)noneNodeList.item(0);
            mainConfig.setHAPolicyConfiguration(this.createLiveOnlyHaPolicy(noneNode));
        }
    }

    private LiveOnlyPolicyConfiguration createLiveOnlyHaPolicy(Element policyNode) {
        LiveOnlyPolicyConfiguration configuration = new LiveOnlyPolicyConfiguration();
        configuration.setScaleDownConfiguration(this.parseScaleDownConfig(policyNode));
        return configuration;
    }

    private ReplicatedPolicyConfiguration createReplicatedHaPolicy(Element policyNode) {
        ReplicatedPolicyConfiguration configuration = new ReplicatedPolicyConfiguration();
        configuration.setCheckForLiveServer(FileConfigurationParser.getBoolean(policyNode, "check-for-live-server", configuration.isCheckForLiveServer()));
        configuration.setGroupName(FileConfigurationParser.getString(policyNode, "group-name", configuration.getGroupName(), Validators.NO_CHECK));
        configuration.setClusterName(FileConfigurationParser.getString(policyNode, "cluster-name", configuration.getClusterName(), Validators.NO_CHECK));
        configuration.setInitialReplicationSyncTimeout(FileConfigurationParser.getLong(policyNode, "initial-replication-sync-timeout", configuration.getInitialReplicationSyncTimeout(), Validators.GT_ZERO));
        return configuration;
    }

    private ReplicaPolicyConfiguration createReplicaHaPolicy(Element policyNode) {
        ReplicaPolicyConfiguration configuration = new ReplicaPolicyConfiguration();
        configuration.setRestartBackup(FileConfigurationParser.getBoolean(policyNode, "restart-backup", configuration.isRestartBackup()));
        configuration.setGroupName(FileConfigurationParser.getString(policyNode, "group-name", configuration.getGroupName(), Validators.NO_CHECK));
        configuration.setAllowFailBack(FileConfigurationParser.getBoolean(policyNode, "allow-failback", configuration.isAllowFailBack()));
        configuration.setInitialReplicationSyncTimeout(FileConfigurationParser.getLong(policyNode, "initial-replication-sync-timeout", configuration.getInitialReplicationSyncTimeout(), Validators.GT_ZERO));
        configuration.setClusterName(FileConfigurationParser.getString(policyNode, "cluster-name", configuration.getClusterName(), Validators.NO_CHECK));
        configuration.setMaxSavedReplicatedJournalsSize(FileConfigurationParser.getInteger(policyNode, "max-saved-replicated-journals-size", configuration.getMaxSavedReplicatedJournalsSize(), Validators.MINUS_ONE_OR_GE_ZERO));
        configuration.setScaleDownConfiguration(this.parseScaleDownConfig(policyNode));
        return configuration;
    }

    private SharedStoreMasterPolicyConfiguration createSharedStoreMasterHaPolicy(Element policyNode) {
        SharedStoreMasterPolicyConfiguration configuration = new SharedStoreMasterPolicyConfiguration();
        configuration.setFailoverOnServerShutdown(FileConfigurationParser.getBoolean(policyNode, "failover-on-shutdown", configuration.isFailoverOnServerShutdown()));
        return configuration;
    }

    private SharedStoreSlavePolicyConfiguration createSharedStoreSlaveHaPolicy(Element policyNode) {
        SharedStoreSlavePolicyConfiguration configuration = new SharedStoreSlavePolicyConfiguration();
        configuration.setAllowFailBack(FileConfigurationParser.getBoolean(policyNode, "allow-failback", configuration.isAllowFailBack()));
        configuration.setFailoverOnServerShutdown(FileConfigurationParser.getBoolean(policyNode, "failover-on-shutdown", configuration.isFailoverOnServerShutdown()));
        configuration.setRestartBackup(FileConfigurationParser.getBoolean(policyNode, "restart-backup", configuration.isRestartBackup()));
        configuration.setScaleDownConfiguration(this.parseScaleDownConfig(policyNode));
        return configuration;
    }

    private ColocatedPolicyConfiguration createColocatedHaPolicy(Element policyNode, boolean replicated) {
        NodeList slaveNodeList;
        NodeList masterNodeList;
        ColocatedPolicyConfiguration configuration = new ColocatedPolicyConfiguration();
        boolean requestBackup = FileConfigurationParser.getBoolean(policyNode, "request-backup", configuration.isRequestBackup());
        configuration.setRequestBackup(requestBackup);
        int backupRequestRetries = FileConfigurationParser.getInteger(policyNode, "backup-request-retries", configuration.getBackupRequestRetries(), Validators.MINUS_ONE_OR_GE_ZERO);
        configuration.setBackupRequestRetries(backupRequestRetries);
        long backupRequestRetryInterval = FileConfigurationParser.getLong(policyNode, "backup-request-retry-interval", configuration.getBackupRequestRetryInterval(), Validators.GT_ZERO);
        configuration.setBackupRequestRetryInterval(backupRequestRetryInterval);
        int maxBackups = FileConfigurationParser.getInteger(policyNode, "max-backups", configuration.getMaxBackups(), Validators.GE_ZERO);
        configuration.setMaxBackups(maxBackups);
        int backupPortOffset = FileConfigurationParser.getInteger(policyNode, "backup-port-offset", configuration.getBackupPortOffset(), Validators.GT_ZERO);
        configuration.setBackupPortOffset(backupPortOffset);
        NodeList remoteConnectorNode = policyNode.getElementsByTagName("excludes");
        if (remoteConnectorNode != null && remoteConnectorNode.getLength() > 0) {
            NodeList remoteConnectors = remoteConnectorNode.item(0).getChildNodes();
            for (int i = 0; i < remoteConnectors.getLength(); ++i) {
                Node child = remoteConnectors.item(i);
                if (!child.getNodeName().equals("connector-ref")) continue;
                String connectorName = FileConfigurationParser.getTrimmedTextContent(child);
                configuration.getExcludedConnectors().add(connectorName);
            }
        }
        if ((masterNodeList = policyNode.getElementsByTagName("master")).getLength() > 0) {
            Element masterNode = (Element)masterNodeList.item(0);
            configuration.setLiveConfig(replicated ? this.createReplicatedHaPolicy(masterNode) : this.createSharedStoreMasterHaPolicy(masterNode));
        }
        if ((slaveNodeList = policyNode.getElementsByTagName("slave")).getLength() > 0) {
            Element slaveNode = (Element)slaveNodeList.item(0);
            configuration.setBackupConfig(replicated ? this.createReplicaHaPolicy(slaveNode) : this.createSharedStoreSlaveHaPolicy(slaveNode));
        }
        return configuration;
    }

    private ScaleDownConfiguration parseScaleDownConfig(Element policyNode) {
        NodeList scaleDownNode = policyNode.getElementsByTagName("scale-down");
        if (scaleDownNode.getLength() > 0) {
            ScaleDownConfiguration scaleDownConfiguration = new ScaleDownConfiguration();
            Element scaleDownElement = (Element)scaleDownNode.item(0);
            scaleDownConfiguration.setEnabled(FileConfigurationParser.getBoolean(scaleDownElement, "enabled", scaleDownConfiguration.isEnabled()));
            NodeList discoveryGroupRef = scaleDownElement.getElementsByTagName("discovery-group-ref");
            if (discoveryGroupRef.item(0) != null) {
                scaleDownConfiguration.setDiscoveryGroup(discoveryGroupRef.item(0).getAttributes().getNamedItem("discovery-group-name").getNodeValue());
            }
            String scaleDownGroupName = FileConfigurationParser.getString(scaleDownElement, "group-name", scaleDownConfiguration.getGroupName(), Validators.NO_CHECK);
            scaleDownConfiguration.setGroupName(scaleDownGroupName);
            NodeList scaleDownConnectorNode = scaleDownElement.getElementsByTagName("connectors");
            if (scaleDownConnectorNode != null && scaleDownConnectorNode.getLength() > 0) {
                NodeList scaleDownConnectors = scaleDownConnectorNode.item(0).getChildNodes();
                for (int i = 0; i < scaleDownConnectors.getLength(); ++i) {
                    Node child = scaleDownConnectors.item(i);
                    if (!child.getNodeName().equals("connector-ref")) continue;
                    String connectorName = FileConfigurationParser.getTrimmedTextContent(child);
                    scaleDownConfiguration.getConnectors().add(connectorName);
                }
            }
            return scaleDownConfiguration;
        }
        return null;
    }

    private DatabaseStorageConfiguration createDatabaseStoreConfig(Element storeNode) {
        DatabaseStorageConfiguration conf = new DatabaseStorageConfiguration();
        conf.setBindingsTableName(FileConfigurationParser.getString(storeNode, "bindings-table-name", conf.getBindingsTableName(), Validators.NO_CHECK));
        conf.setMessageTableName(FileConfigurationParser.getString(storeNode, "message-table-name", conf.getMessageTableName(), Validators.NO_CHECK));
        conf.setLargeMessageTableName(FileConfigurationParser.getString(storeNode, "large-message-table-name", conf.getJdbcConnectionUrl(), Validators.NO_CHECK));
        conf.setJdbcConnectionUrl(FileConfigurationParser.getString(storeNode, "jdbc-connection-url", conf.getJdbcConnectionUrl(), Validators.NO_CHECK));
        conf.setJdbcDriverClassName(FileConfigurationParser.getString(storeNode, "jdbc-driver-class-name", conf.getJdbcDriverClassName(), Validators.NO_CHECK));
        return conf;
    }

    private FileStorageConfiguration createFileStoreConfig(Element storeNode) {
        return new FileStorageConfiguration();
    }

    private void parseBroadcastGroupConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute(NAME_ATTR_NAME);
        ArrayList<String> connectorNames = new ArrayList<String>();
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("connector-ref")) continue;
            String connectorName = FileConfigurationParser.getString(e, "connector-ref", null, Validators.NOT_NULL_OR_EMPTY);
            connectorNames.add(connectorName);
        }
        long broadcastPeriod = FileConfigurationParser.getLong(e, "broadcast-period", ActiveMQDefaultConfiguration.getDefaultBroadcastPeriod(), Validators.GT_ZERO);
        String localAddress = FileConfigurationParser.getString(e, "local-bind-address", null, Validators.NO_CHECK);
        int localBindPort = FileConfigurationParser.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String groupAddress = FileConfigurationParser.getString(e, "group-address", null, Validators.NO_CHECK);
        int groupPort = FileConfigurationParser.getInteger(e, "group-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String jgroupsFile = FileConfigurationParser.getString(e, "jgroups-file", null, Validators.NO_CHECK);
        String jgroupsChannel = FileConfigurationParser.getString(e, "jgroups-channel", null, Validators.NO_CHECK);
        Object endpointFactory = jgroupsFile != null ? new JGroupsFileBroadcastEndpointFactory().setFile(jgroupsFile).setChannelName(jgroupsChannel) : new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort).setLocalBindAddress(localAddress).setLocalBindPort(localBindPort);
        BroadcastGroupConfiguration config = new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorNames).setEndpointFactory((BroadcastEndpointFactory)endpointFactory);
        mainConfig.getBroadcastGroupConfigurations().add(config);
    }

    private void parseDiscoveryGroupConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute(NAME_ATTR_NAME);
        long discoveryInitialWaitTimeout = FileConfigurationParser.getLong(e, "initial-wait-timeout", 10000L, Validators.GT_ZERO);
        long refreshTimeout = FileConfigurationParser.getLong(e, "refresh-timeout", ActiveMQDefaultConfiguration.getDefaultBroadcastRefreshTimeout(), Validators.GT_ZERO);
        String localBindAddress = FileConfigurationParser.getString(e, "local-bind-address", null, Validators.NO_CHECK);
        int localBindPort = FileConfigurationParser.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String groupAddress = FileConfigurationParser.getString(e, "group-address", null, Validators.NO_CHECK);
        int groupPort = FileConfigurationParser.getInteger(e, "group-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String jgroupsFile = FileConfigurationParser.getString(e, "jgroups-file", null, Validators.NO_CHECK);
        String jgroupsChannel = FileConfigurationParser.getString(e, "jgroups-channel", null, Validators.NO_CHECK);
        Object endpointFactory = jgroupsFile != null ? new JGroupsFileBroadcastEndpointFactory().setFile(jgroupsFile).setChannelName(jgroupsChannel) : new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort).setLocalBindAddress(localBindAddress).setLocalBindPort(localBindPort);
        DiscoveryGroupConfiguration config = new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
        if (mainConfig.getDiscoveryGroupConfigurations().containsKey(name)) {
            ActiveMQServerLogger.LOGGER.discoveryGroupAlreadyDeployed(name);
            return;
        }
        mainConfig.getDiscoveryGroupConfigurations().put(name, config);
    }

    private void parseClusterConnectionConfigurationURI(Element e, Configuration mainConfig) throws Exception {
        String name = e.getAttribute(NAME_ATTR_NAME);
        String uri = e.getAttribute("address");
        ClusterConnectionConfiguration config = mainConfig.addClusterConfiguration(name, uri);
        System.out.println("Adding cluster connection :: " + config);
    }

    private void parseClusterConnectionConfiguration(Element e, Configuration mainConfig) throws Exception {
        boolean forwardWhenNoConsumers;
        String name = e.getAttribute(NAME_ATTR_NAME);
        String address = FileConfigurationParser.getString(e, "address", null, Validators.NOT_NULL_OR_EMPTY);
        String connectorName = FileConfigurationParser.getString(e, "connector-ref", null, Validators.NOT_NULL_OR_EMPTY);
        boolean duplicateDetection = FileConfigurationParser.getBoolean(e, "use-duplicate-detection", ActiveMQDefaultConfiguration.isDefaultClusterDuplicateDetection());
        MessageLoadBalancingType messageLoadBalancingType = FileConfigurationParser.parameterExists(e, "forward-when-no-consumers").booleanValue() ? ((forwardWhenNoConsumers = FileConfigurationParser.getBoolean(e, "forward-when-no-consumers", ActiveMQDefaultConfiguration.isDefaultClusterForwardWhenNoConsumers()).booleanValue()) ? MessageLoadBalancingType.STRICT : MessageLoadBalancingType.ON_DEMAND) : Enum.valueOf(MessageLoadBalancingType.class, FileConfigurationParser.getString(e, "message-load-balancing", ActiveMQDefaultConfiguration.getDefaultClusterMessageLoadBalancingType(), Validators.MESSAGE_LOAD_BALANCING_TYPE));
        int maxHops = FileConfigurationParser.getInteger(e, "max-hops", ActiveMQDefaultConfiguration.getDefaultClusterMaxHops(), Validators.GE_ZERO);
        long clientFailureCheckPeriod = FileConfigurationParser.getLong(e, "check-period", ActiveMQDefaultConfiguration.getDefaultClusterFailureCheckPeriod(), Validators.GT_ZERO);
        long connectionTTL = FileConfigurationParser.getLong(e, "connection-ttl", ActiveMQDefaultConfiguration.getDefaultClusterConnectionTtl(), Validators.GT_ZERO);
        long retryInterval = FileConfigurationParser.getLong(e, "retry-interval", ActiveMQDefaultConfiguration.getDefaultClusterRetryInterval(), Validators.GT_ZERO);
        long callTimeout = FileConfigurationParser.getLong(e, "call-timeout", 30000L, Validators.GT_ZERO);
        long callFailoverTimeout = FileConfigurationParser.getLong(e, "call-failover-timeout", 30000L, Validators.MINUS_ONE_OR_GT_ZERO);
        double retryIntervalMultiplier = FileConfigurationParser.getDouble(e, "retry-interval-multiplier", ActiveMQDefaultConfiguration.getDefaultClusterRetryIntervalMultiplier(), Validators.GT_ZERO);
        int minLargeMessageSize = FileConfigurationParser.getInteger(e, "min-large-message-size", 102400, Validators.GT_ZERO);
        long maxRetryInterval = FileConfigurationParser.getLong(e, "max-retry-interval", ActiveMQDefaultConfiguration.getDefaultClusterMaxRetryInterval(), Validators.GT_ZERO);
        int initialConnectAttempts = FileConfigurationParser.getInteger(e, "initial-connect-attempts", ActiveMQDefaultConfiguration.getDefaultClusterInitialConnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttempts = FileConfigurationParser.getInteger(e, "reconnect-attempts", ActiveMQDefaultConfiguration.getDefaultClusterReconnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int confirmationWindowSize = FileConfigurationParser.getInteger(e, "confirmation-window-size", ActiveMQDefaultConfiguration.getDefaultClusterConfirmationWindowSize(), Validators.GT_ZERO);
        long clusterNotificationInterval = FileConfigurationParser.getLong(e, "notification-interval", ActiveMQDefaultConfiguration.getDefaultClusterNotificationInterval(), Validators.GT_ZERO);
        int clusterNotificationAttempts = FileConfigurationParser.getInteger(e, "notification-attempts", ActiveMQDefaultConfiguration.getDefaultClusterNotificationAttempts(), Validators.GT_ZERO);
        String scaleDownConnector = e.getAttribute("scale-down-connector");
        String discoveryGroupName = null;
        ArrayList<String> staticConnectorNames = new ArrayList<String>();
        boolean allowDirectConnectionsOnly = false;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("static-connectors")) continue;
            Node attr = child.getAttributes().getNamedItem("allow-direct-connections-only");
            if (attr != null) {
                allowDirectConnectionsOnly = "true".equalsIgnoreCase(attr.getNodeValue()) || allowDirectConnectionsOnly;
            }
            this.getStaticConnectors(staticConnectorNames, child);
        }
        ClusterConnectionConfiguration config = new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(connectorName).setMinLargeMessageSize(minLargeMessageSize).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setMaxRetryInterval(maxRetryInterval).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setCallTimeout(callTimeout).setCallFailoverTimeout(callFailoverTimeout).setDuplicateDetection(duplicateDetection).setMessageLoadBalancingType(messageLoadBalancingType).setMaxHops(maxHops).setConfirmationWindowSize(confirmationWindowSize).setAllowDirectConnectionsOnly(allowDirectConnectionsOnly).setClusterNotificationInterval(clusterNotificationInterval).setClusterNotificationAttempts(clusterNotificationAttempts);
        if (discoveryGroupName == null) {
            config.setStaticConnectors(staticConnectorNames);
        } else {
            config.setDiscoveryGroupName(discoveryGroupName);
        }
        mainConfig.getClusterConfigurations().add(config);
    }

    private void parseGroupingHandlerConfiguration(Element node, Configuration mainConfiguration) {
        String name = node.getAttribute(NAME_ATTR_NAME);
        String type = FileConfigurationParser.getString(node, TYPE_ATTR_NAME, null, Validators.NOT_NULL_OR_EMPTY);
        String address = FileConfigurationParser.getString(node, "address", null, Validators.NOT_NULL_OR_EMPTY);
        Integer timeout = FileConfigurationParser.getInteger(node, "timeout", ActiveMQDefaultConfiguration.getDefaultGroupingHandlerTimeout(), Validators.GT_ZERO);
        Long groupTimeout = FileConfigurationParser.getLong(node, "group-timeout", ActiveMQDefaultConfiguration.getDefaultGroupingHandlerGroupTimeout(), Validators.MINUS_ONE_OR_GT_ZERO);
        Long reaperPeriod = FileConfigurationParser.getLong(node, "reaper-period", ActiveMQDefaultConfiguration.getDefaultGroupingHandlerReaperPeriod(), Validators.GT_ZERO);
        mainConfiguration.setGroupingHandlerConfiguration(new GroupingHandlerConfiguration().setName(new SimpleString(name)).setType(type.equals(GroupingHandlerConfiguration.TYPE.LOCAL.getType()) ? GroupingHandlerConfiguration.TYPE.LOCAL : GroupingHandlerConfiguration.TYPE.REMOTE).setAddress(new SimpleString(address)).setTimeout(timeout.intValue()).setGroupTimeout(groupTimeout).setReaperPeriod(reaperPeriod));
    }

    private void parseBridgeConfiguration(Element brNode, Configuration mainConfig) throws Exception {
        String name = brNode.getAttribute(NAME_ATTR_NAME);
        String queueName = FileConfigurationParser.getString(brNode, "queue-name", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = FileConfigurationParser.getString(brNode, "forwarding-address", null, Validators.NO_CHECK);
        String transformerClassName = FileConfigurationParser.getString(brNode, "transformer-class-name", null, Validators.NO_CHECK);
        int confirmationWindowSize = FileConfigurationParser.getInteger(brNode, "confirmation-window-size", ActiveMQDefaultConfiguration.getDefaultBridgeConfirmationWindowSize(), Validators.GT_ZERO);
        long retryInterval = FileConfigurationParser.getLong(brNode, "retry-interval", 2000L, Validators.GT_ZERO);
        long clientFailureCheckPeriod = FileConfigurationParser.getLong(brNode, "check-period", ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, Validators.GT_ZERO);
        long connectionTTL = FileConfigurationParser.getLong(brNode, "connection-ttl", ActiveMQClient.DEFAULT_CONNECTION_TTL, Validators.GT_ZERO);
        int minLargeMessageSize = FileConfigurationParser.getInteger(brNode, "min-large-message-size", 102400, Validators.GT_ZERO);
        long maxRetryInterval = FileConfigurationParser.getLong(brNode, "max-retry-interval", ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL, Validators.GT_ZERO);
        double retryIntervalMultiplier = FileConfigurationParser.getDouble(brNode, "retry-interval-multiplier", ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, Validators.GT_ZERO);
        int initialConnectAttempts = FileConfigurationParser.getInteger(brNode, "initial-connect-attempts", ActiveMQDefaultConfiguration.getDefaultBridgeInitialConnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttempts = FileConfigurationParser.getInteger(brNode, "reconnect-attempts", ActiveMQDefaultConfiguration.getDefaultBridgeReconnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttemptsSameNode = FileConfigurationParser.getInteger(brNode, "reconnect-attempts-same-node", ActiveMQDefaultConfiguration.getDefaultBridgeConnectSameNode(), Validators.MINUS_ONE_OR_GE_ZERO);
        boolean useDuplicateDetection = FileConfigurationParser.getBoolean(brNode, "use-duplicate-detection", ActiveMQDefaultConfiguration.isDefaultBridgeDuplicateDetection());
        String user = FileConfigurationParser.getString(brNode, "user", ActiveMQDefaultConfiguration.getDefaultClusterUser(), Validators.NO_CHECK);
        NodeList clusterPassNodes = brNode.getElementsByTagName("password");
        String password = null;
        boolean maskPassword = mainConfig.isMaskPassword();
        SensitiveDataCodec codec = null;
        if (clusterPassNodes.getLength() > 0) {
            Node passNode = clusterPassNodes.item(0);
            password = passNode.getTextContent();
        }
        if (password != null) {
            if (maskPassword) {
                codec = PasswordMaskingUtil.getCodec((String)mainConfig.getPasswordCodec());
                password = (String)codec.decode((Object)password);
            }
        } else {
            password = ActiveMQDefaultConfiguration.getDefaultClusterPassword();
        }
        boolean ha = FileConfigurationParser.getBoolean(brNode, "ha", false);
        String filterString = null;
        ArrayList<String> staticConnectorNames = new ArrayList<String>();
        String discoveryGroupName = null;
        NodeList children = brNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("filter")) {
                filterString = child.getAttributes().getNamedItem("string").getNodeValue();
                continue;
            }
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("static-connectors")) continue;
            this.getStaticConnectors(staticConnectorNames, child);
        }
        BridgeConfiguration config = new BridgeConfiguration().setName(name).setQueueName(queueName).setForwardingAddress(forwardingAddress).setFilterString(filterString).setTransformerClassName(transformerClassName).setMinLargeMessageSize(minLargeMessageSize).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setRetryInterval(retryInterval).setMaxRetryInterval(maxRetryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setReconnectAttemptsOnSameNode(reconnectAttemptsSameNode).setUseDuplicateDetection(useDuplicateDetection).setConfirmationWindowSize(confirmationWindowSize).setHA(ha).setUser(user).setPassword(password);
        if (!staticConnectorNames.isEmpty()) {
            config.setStaticConnectors(staticConnectorNames);
        } else {
            config.setDiscoveryGroupName(discoveryGroupName);
        }
        mainConfig.getBridgeConfigurations().add(config);
    }

    private void getStaticConnectors(List<String> staticConnectorNames, Node child) {
        NodeList children2 = ((Element)child).getElementsByTagName("connector-ref");
        for (int k = 0; k < children2.getLength(); ++k) {
            Element child2 = (Element)children2.item(k);
            String connectorName = child2.getChildNodes().item(0).getNodeValue();
            staticConnectorNames.add(connectorName);
        }
    }

    private void parseDivertConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute(NAME_ATTR_NAME);
        String routingName = FileConfigurationParser.getString(e, "routing-name", null, Validators.NO_CHECK);
        String address = FileConfigurationParser.getString(e, "address", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = FileConfigurationParser.getString(e, "forwarding-address", null, Validators.NOT_NULL_OR_EMPTY);
        boolean exclusive = FileConfigurationParser.getBoolean(e, "exclusive", ActiveMQDefaultConfiguration.isDefaultDivertExclusive());
        String transformerClassName = FileConfigurationParser.getString(e, "transformer-class-name", null, Validators.NO_CHECK);
        String filterString = null;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("filter")) continue;
            filterString = FileConfigurationParser.getAttributeValue(child, "string");
        }
        DivertConfiguration config = new DivertConfiguration().setName(name).setRoutingName(routingName).setAddress(address).setForwardingAddress(forwardingAddress).setExclusive(exclusive).setFilterString(filterString).setTransformerClassName(transformerClassName);
        mainConfig.getDivertConfigurations().add(config);
    }

    private ConnectorServiceConfiguration parseConnectorService(Element e) {
        Node nameNode = e.getAttributes().getNamedItem(NAME_ATTR_NAME);
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String clazz = FileConfigurationParser.getString(e, "factory-class", null, Validators.NOT_NULL_OR_EMPTY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        NodeList paramsNodes = e.getElementsByTagName("param");
        for (int i = 0; i < paramsNodes.getLength(); ++i) {
            Node paramNode = paramsNodes.item(i);
            NamedNodeMap attributes = paramNode.getAttributes();
            Node nkey = attributes.getNamedItem("key");
            String key = nkey.getTextContent();
            Node nValue = attributes.getNamedItem(VALUE_ATTR_NAME);
            params.put(key, nValue.getTextContent());
        }
        return new ConnectorServiceConfiguration().setFactoryClassName(clazz).setParams(params).setName(name);
    }

    static {
        POLICY_LIST.add("colocated");
        POLICY_LIST.add("live-only");
        POLICY_LIST.add("replicated");
        POLICY_LIST.add("replica");
        POLICY_LIST.add("shared-store-master");
        POLICY_LIST.add("shared-store-slave");
        HA_LIST = new ArrayList();
        HA_LIST.add("live-only");
        HA_LIST.add("shared-store");
        HA_LIST.add("replication");
        STORE_TYPE_LIST = new ArrayList();
        STORE_TYPE_LIST.add("database-store");
        STORE_TYPE_LIST.add("file-store");
    }
}

