/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter.message;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.AMQPNativeInboundTransformer;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.EncodedMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.InboundTransformer;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.JMSVendor;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class JMSMappingInboundTransformer
extends InboundTransformer {
    public JMSMappingInboundTransformer(JMSVendor vendor) {
        super(vendor);
    }

    @Override
    public String getTransformerName() {
        return "jms";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return new AMQPNativeInboundTransformer(this.getVendor());
    }

    @Override
    public javax.jms.Message transform(EncodedMessage amqpMessage) throws Exception {
        javax.jms.Message rc;
        Message amqp = amqpMessage.decode();
        Section body = amqp.getBody();
        if (body == null) {
            rc = this.vendor.createMessage();
        } else if (body instanceof Data) {
            Binary d = ((Data)body).getValue();
            BytesMessage m = this.vendor.createBytesMessage();
            m.writeBytes(d.getArray(), d.getArrayOffset(), d.getLength());
            rc = m;
        } else if (body instanceof AmqpSequence) {
            AmqpSequence sequence = (AmqpSequence)body;
            StreamMessage m = this.vendor.createStreamMessage();
            for (Object item : sequence.getValue()) {
                m.writeObject(item);
            }
            rc = m;
            m.setStringProperty("amqp:type", "amqp:sequence");
        } else if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value == null) {
                rc = this.vendor.createObjectMessage();
            }
            if (value instanceof String) {
                TextMessage m = this.vendor.createTextMessage();
                m.setText((String)value);
                rc = m;
            } else if (value instanceof Binary) {
                Binary d = (Binary)value;
                BytesMessage m = this.vendor.createBytesMessage();
                m.writeBytes(d.getArray(), d.getArrayOffset(), d.getLength());
                rc = m;
            } else if (value instanceof List) {
                StreamMessage m = this.vendor.createStreamMessage();
                for (Object item : (List)value) {
                    m.writeObject(item);
                }
                rc = m;
                m.setStringProperty("amqp:type", "amqp:list");
            } else if (value instanceof Map) {
                MapMessage m = this.vendor.createMapMessage();
                Set set = ((Map)value).entrySet();
                for (Map.Entry entry : set) {
                    m.setObject((String)entry.getKey(), entry.getValue());
                }
                rc = m;
            } else {
                ObjectMessage m = this.vendor.createObjectMessage();
                m.setObject((Serializable)value);
                rc = m;
            }
        } else {
            throw new RuntimeException("Unexpected body type: " + body.getClass());
        }
        rc.setJMSDeliveryMode(this.defaultDeliveryMode);
        rc.setJMSPriority(this.defaultPriority);
        rc.setJMSExpiration(this.defaultTtl);
        this.populateMessage(rc, amqp);
        rc.setLongProperty(this.prefixVendor + "MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        rc.setBooleanProperty(this.prefixVendor + "NATIVE", false);
        return rc;
    }
}

