/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter.message;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.JMSVendor;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.OutboundTransformer;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.ProtonJMessage;

public class AMQPNativeOutboundTransformer
extends OutboundTransformer {
    public AMQPNativeOutboundTransformer(JMSVendor vendor) {
        super(vendor);
    }

    public static ProtonJMessage transform(OutboundTransformer options, BytesMessage msg) throws JMSException {
        int decoded;
        byte[] data = new byte[(int)msg.getBodyLength()];
        msg.readBytes(data);
        msg.reset();
        int count = msg.getIntProperty("JMSXDeliveryCount");
        ProtonJMessage amqp = (ProtonJMessage)Message.Factory.create();
        int offset = 0;
        for (int len = data.length; len > 0; len -= decoded) {
            decoded = amqp.decode(data, offset, len);
            assert (decoded > 0) : "Make progress decoding the message";
            offset += decoded;
        }
        if (amqp.getHeader() == null) {
            amqp.setHeader(new Header());
        }
        amqp.getHeader().setDeliveryCount(new UnsignedInteger(count - 1));
        return amqp;
    }
}

