/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter.message;

import org.apache.activemq.artemis.core.protocol.proton.converter.message.AMQPRawInboundTransformer;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.EncodedMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.InboundTransformer;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.JMSVendor;
import org.apache.qpid.proton.message.Message;

public class AMQPNativeInboundTransformer
extends AMQPRawInboundTransformer {
    public AMQPNativeInboundTransformer(JMSVendor vendor) {
        super(vendor);
    }

    @Override
    public String getTransformerName() {
        return "native";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return new AMQPRawInboundTransformer(this.getVendor());
    }

    @Override
    public javax.jms.Message transform(EncodedMessage amqpMessage) throws Exception {
        Message amqp = amqpMessage.decode();
        javax.jms.Message rc = super.transform(amqpMessage);
        this.populateMessage(rc, amqp);
        return rc;
    }
}

