/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSMessage;

public class ServerJMSObjectMessage
extends ServerJMSMessage
implements ObjectMessage {
    public static final byte TYPE = 6;
    private Serializable object;

    public ServerJMSObjectMessage(MessageInternal message, int deliveryCount) {
        super(message, deliveryCount);
    }

    public void setObject(Serializable object) throws JMSException {
        this.object = object;
    }

    public Serializable getObject() throws JMSException {
        return this.object;
    }

    @Override
    public void encode() throws Exception {
        super.encode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream ous = new ObjectOutputStream(out);
        ous.writeObject(this.object);
        this.getInnerMessage().getBodyBuffer().writeBytes(out.toByteArray());
    }

    @Override
    public void decode() throws Exception {
        super.decode();
        int size = this.getInnerMessage().getBodyBuffer().readableBytes();
        byte[] bytes = new byte[size];
        this.getInnerMessage().getBodyBuffer().readBytes(bytes);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        this.object = (Serializable)ois.readObject();
    }
}

