/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;

public interface AddressControl {
    @Attribute(desc="managed address")
    public String getAddress();

    @Attribute(desc="roles (name and permissions) associated with this address")
    public Object[] getRoles() throws Exception;

    @Attribute(desc="roles  (name and permissions) associated with this address using JSON serialization")
    public String getRolesAsJSON() throws Exception;

    @Operation(desc="returns the number of estimated bytes being used by the queue, used to control paging and blocking", impact=0)
    public long getAddressSize() throws Exception;

    @Operation(desc="Returns the sum of messages on queues, including messages in delivery", impact=0)
    public long getNumberOfMessages() throws Exception;

    @Attribute(desc="names of the queues bound to this address")
    public String[] getQueueNames() throws Exception;

    @Attribute(desc="number of pages used by this address")
    public int getNumberOfPages() throws Exception;

    @Attribute(desc="whether this address is paging")
    public boolean isPaging() throws Exception;

    @Attribute(desc="number of bytes used by each page for this address")
    public long getNumberOfBytesPerPage() throws Exception;

    @Attribute(desc="names of all bindings (both queues and diverts) bound to this address")
    public String[] getBindingNames() throws Exception;
}

