/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.activemq.artemis.ActiveMQWebLogger;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServerComponent
implements ExternalComponent {
    private Server server;
    private HandlerList handlers;
    private WebServerDTO webServerConfig;
    private URI uri;
    private String jolokiaUrl;

    public void configure(ComponentDTO config, String artemisInstance, String artemisHome) throws Exception {
        this.webServerConfig = (WebServerDTO)config;
        this.uri = new URI(this.webServerConfig.bind);
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.uri.getPort());
        connector.setHost(this.uri.getHost());
        this.server.setConnectors(new Connector[]{connector});
        this.handlers = new HandlerList();
        Path warDir = Paths.get(artemisHome != null ? artemisHome : ".", new String[0]).resolve(this.webServerConfig.path).toAbsolutePath();
        if (this.webServerConfig.apps != null) {
            for (AppDTO app : this.webServerConfig.apps) {
                this.deployWar(app.url, app.war, warDir);
                if (!app.war.startsWith("jolokia")) continue;
                this.jolokiaUrl = this.webServerConfig.bind + "/" + app.url;
            }
        }
        WebAppContext handler = new WebAppContext();
        handler.setContextPath("/");
        handler.setResourceBase(warDir.toString());
        handler.setLogUrlOnStart(true);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(warDir.toString());
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServeIcon(false);
        this.handlers.addHandler((Handler)resourceHandler);
        this.handlers.addHandler((Handler)defaultHandler);
        this.server.setHandler((Handler)this.handlers);
    }

    public void start() throws Exception {
        this.server.start();
        ActiveMQWebLogger.LOGGER.webserverStarted(this.webServerConfig.bind);
        if (this.jolokiaUrl != null) {
            ActiveMQWebLogger.LOGGER.jolokiaAvailable(this.jolokiaUrl);
        }
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public boolean isStarted() {
        return this.server != null && this.server.isStarted();
    }

    private void deployWar(String url, String warFile, Path warDirectory) throws IOException {
        WebAppContext webapp = new WebAppContext();
        if (url.startsWith("/")) {
            webapp.setContextPath(url);
        } else {
            webapp.setContextPath("/" + url);
        }
        webapp.setWar(warDirectory.resolve(warFile).toString());
        this.handlers.addHandler((Handler)webapp);
    }
}

