/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.util;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.HttpHeaderProperty;
import org.jboss.resteasy.client.ClientRequest;

public class HttpMessageHelper {
    public static final String POSTED_AS_HTTP_MESSAGE = "postedAsHttpMessage";

    public static boolean isTransferableHttpHeader(String key) {
        String lowerKey = key.toLowerCase();
        return lowerKey.toLowerCase().startsWith("content") || lowerKey.toLowerCase().equals("link");
    }

    public static void buildMessage(ClientMessage message, Response.ResponseBuilder builder) {
        for (SimpleString key : message.getPropertyNames()) {
            String k = key.toString();
            String headerName = HttpHeaderProperty.fromPropertyName(k);
            if (headerName == null) continue;
            builder.header(headerName, (Object)message.getStringProperty(k));
        }
        int size = message.getBodySize();
        if (size > 0) {
            byte[] body = new byte[size];
            message.getBodyBuffer().readBytes(body);
            Boolean aBoolean = message.getBooleanProperty(POSTED_AS_HTTP_MESSAGE);
            if (aBoolean != null && aBoolean.booleanValue()) {
                builder.entity((Object)body);
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(body);
                Object obj = null;
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    obj = ois.readObject();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                builder.entity(obj);
            }
        }
    }

    public static void buildMessage(ClientMessage message, ClientRequest request, String contentType) {
        for (SimpleString key : message.getPropertyNames()) {
            String k = key.toString();
            String headerName = HttpHeaderProperty.fromPropertyName(k);
            if (headerName == null || headerName.contains("content-length")) continue;
            String value = message.getStringProperty(k);
            request.header(headerName, (Object)value);
            ActiveMQRestLogger.LOGGER.debug("Examining " + headerName + ": " + value);
            if (!headerName.equalsIgnoreCase("content-type")) continue;
            contentType = value;
            ActiveMQRestLogger.LOGGER.debug("Using contentType: " + contentType);
        }
        int size = message.getBodySize();
        if (size > 0) {
            byte[] body;
            Boolean aBoolean = message.getBooleanProperty(POSTED_AS_HTTP_MESSAGE);
            if (aBoolean != null && aBoolean.booleanValue()) {
                body = new byte[size];
                message.getBodyBuffer().readBytes(body);
                ActiveMQRestLogger.LOGGER.debug("Building Message from HTTP message");
                request.body(contentType, (Object)body);
            } else {
                size = message.getBodyBuffer().readInt();
                body = new byte[size];
                message.getBodyBuffer().readBytes(body);
                ByteArrayInputStream bais = new ByteArrayInputStream(body);
                Object obj = null;
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    obj = ois.readObject();
                    ActiveMQRestLogger.LOGGER.debug("**** Building Message from object: " + obj.toString());
                    request.body(contentType, obj);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void writeHttpMessage(HttpHeaders headers, byte[] body, ClientMessage message) throws Exception {
        MultivaluedMap hdrs = headers.getRequestHeaders();
        for (Map.Entry entry : hdrs.entrySet()) {
            String key = (String)entry.getKey();
            if (!HttpMessageHelper.isTransferableHttpHeader(key)) continue;
            List vals = (List)entry.getValue();
            String value = HttpMessageHelper.concatenateHeaderValue(vals);
            message.putStringProperty(HttpHeaderProperty.toPropertyName(key), value);
        }
        message.putBooleanProperty(POSTED_AS_HTTP_MESSAGE, true);
        message.getBodyBuffer().writeBytes(body);
    }

    public static String concatenateHeaderValue(List<String> vals) {
        if (vals == null) {
            return "";
        }
        StringBuilder val = new StringBuilder();
        for (String v : vals) {
            if (val.length() > 0) {
                val.append(",");
            }
            val.append(v);
        }
        return val.toString();
    }
}

