/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.topic;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.server.config.TopicConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.queue.DestinationSettings;
import org.apache.activemq.artemis.rest.queue.PostMessage;
import org.apache.activemq.artemis.rest.queue.PostMessageDupsOk;
import org.apache.activemq.artemis.rest.queue.PostMessageNoDups;
import org.apache.activemq.artemis.rest.topic.PushSubscriptionsResource;
import org.apache.activemq.artemis.rest.topic.PushTopicRegistration;
import org.apache.activemq.artemis.rest.topic.SubscriptionsResource;
import org.apache.activemq.artemis.rest.topic.TopicResource;
import org.apache.activemq.artemis.rest.topic.TopicServiceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Path(value="/topics")
public class TopicDestinationsResource {
    private Map<String, TopicResource> topics = new ConcurrentHashMap<String, TopicResource>();
    private TopicServiceManager manager;

    public TopicDestinationsResource(TopicServiceManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/activemq.jms.topic+xml"})
    public Response createJmsQueue(@Context UriInfo uriInfo, Document document) {
        ActiveMQRestLogger.LOGGER.debug("Handling POST request for \"" + uriInfo.getPath() + "\"");
        try {
            String topicName;
            block11: {
                TopicConfiguration topic = FileJMSConfiguration.parseTopicConfiguration((Node)document.getDocumentElement());
                ActiveMQTopic activeMQTopic = ActiveMQDestination.createTopic((String)topic.getName());
                topicName = activeMQTopic.getAddress();
                ClientSession session = this.manager.getSessionFactory().createSession(false, false, false);
                try {
                    ClientSession.QueueQuery query = session.queueQuery(new SimpleString(topicName));
                    if (!query.isExists()) {
                        session.createQueue(topicName, topicName, "__AMQX=-1", true);
                        break block11;
                    }
                    throw new WebApplicationException(Response.status((int)412).type("text/plain").entity((Object)"Queue already exists.").build());
                }
                finally {
                    try {
                        session.close();
                    }
                    catch (Exception ignored) {}
                }
            }
            URI uri = uriInfo.getRequestUriBuilder().path(topicName).build(new Object[0]);
            return Response.created((URI)uri).build();
        }
        catch (Exception e) {
            if (e instanceof WebApplicationException) {
                throw (WebApplicationException)e;
            }
            throw new WebApplicationException((Throwable)e, Response.serverError().type("text/plain").entity((Object)"Failed to create queue.").build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/{topic-name}")
    public TopicResource findTopic(@PathParam(value="topic-name") String name) throws Exception {
        TopicResource topic = this.topics.get(name);
        if (topic == null) {
            ClientSession session = this.manager.getSessionFactory().createSession(false, false, false);
            try {
                ClientSession.QueueQuery query = session.queueQuery(new SimpleString(name));
                if (!query.isExists()) {
                    System.err.println("Topic '" + name + "' does not exist");
                    throw new WebApplicationException(Response.status((int)404).type("text/plain").entity((Object)("Topic '" + name + "' does not exist")).build());
                }
                DestinationSettings queueSettings = this.manager.getDefaultSettings();
                boolean defaultDurable = queueSettings.isDurableSend() || query.isDurable();
                topic = this.createTopicResource(name, defaultDurable, queueSettings.getConsumerSessionTimeoutSeconds(), queueSettings.isDuplicatesAllowed());
            }
            finally {
                try {
                    session.close();
                }
                catch (ActiveMQException e) {}
            }
        }
        return topic;
    }

    public Map<String, TopicResource> getTopics() {
        return this.topics;
    }

    public TopicResource createTopicResource(String topicName, boolean defaultDurable, int timeoutSeconds, boolean duplicates) throws Exception {
        TopicResource topicResource = new TopicResource();
        topicResource.setTopicDestinationsResource(this);
        topicResource.setDestination(topicName);
        topicResource.setServiceManager(this.manager);
        SubscriptionsResource subscriptionsResource = new SubscriptionsResource();
        topicResource.setSubscriptions(subscriptionsResource);
        subscriptionsResource.setConsumerTimeoutSeconds(timeoutSeconds);
        subscriptionsResource.setServiceManager(this.manager);
        subscriptionsResource.setDestination(topicName);
        subscriptionsResource.setSessionFactory(this.manager.getConsumerSessionFactory());
        PushSubscriptionsResource push = new PushSubscriptionsResource();
        push.setDestination(topicName);
        push.setSessionFactory(this.manager.getConsumerSessionFactory());
        topicResource.setPushSubscriptions(push);
        PostMessage sender = null;
        sender = duplicates ? new PostMessageDupsOk() : new PostMessageNoDups();
        sender.setDefaultDurable(defaultDurable);
        sender.setDestination(topicName);
        sender.setSessionFactory(this.manager.getSessionFactory());
        sender.setPoolSize(this.manager.getProducerPoolSize());
        sender.setProducerTimeToLive(this.manager.getProducerTimeToLive());
        sender.setServiceManager(this.manager);
        sender.init();
        topicResource.setSender(sender);
        if (this.manager.getPushStore() != null) {
            push.setPushStore(this.manager.getPushStore());
            List<PushTopicRegistration> regs = this.manager.getPushStore().getByTopic(topicName);
            for (PushTopicRegistration reg : regs) {
                push.addRegistration(reg);
            }
        }
        this.getTopics().put(topicName, topicResource);
        topicResource.start();
        return topicResource;
    }
}

