/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.topic;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.queue.push.PushConsumer;
import org.apache.activemq.artemis.rest.queue.push.PushStore;
import org.apache.activemq.artemis.rest.queue.push.xml.PushRegistration;

public class PushSubscription
extends PushConsumer {
    public PushSubscription(ClientSessionFactory factory, String destination, String id, PushRegistration registration, PushStore store) {
        super(factory, destination, id, registration, store);
    }

    @Override
    public void disableFromFailure() {
        super.disableFromFailure();
        if (this.registration.isDurable()) {
            this.deleteSubscriberQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSubscriberQueue() {
        String subscriptionName = this.registration.getDestination();
        ClientSession session = null;
        try {
            session = this.factory.createSession();
            session.deleteQueue(subscriptionName);
        }
        catch (ActiveMQException e) {
            ActiveMQRestLogger.LOGGER.errorDeletingSubscriberQueue(e);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (ActiveMQException activeMQException) {}
        }
    }
}

