/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.queue;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.server.config.JMSQueueConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.queue.ConsumersResource;
import org.apache.activemq.artemis.rest.queue.DestinationSettings;
import org.apache.activemq.artemis.rest.queue.PostMessage;
import org.apache.activemq.artemis.rest.queue.PostMessageDupsOk;
import org.apache.activemq.artemis.rest.queue.PostMessageNoDups;
import org.apache.activemq.artemis.rest.queue.QueueResource;
import org.apache.activemq.artemis.rest.queue.QueueServiceManager;
import org.apache.activemq.artemis.rest.queue.push.PushConsumerResource;
import org.apache.activemq.artemis.rest.queue.push.xml.PushRegistration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Path(value="/queues")
public class QueueDestinationsResource {
    private Map<String, QueueResource> queues = new ConcurrentHashMap<String, QueueResource>();
    private QueueServiceManager manager;

    public QueueDestinationsResource(QueueServiceManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/activemq.jms.queue+xml"})
    public Response createJmsQueue(@Context UriInfo uriInfo, Document document) {
        ActiveMQRestLogger.LOGGER.debug("Handling POST request for \"" + uriInfo.getPath() + "\"");
        try {
            String queueName;
            block13: {
                JMSQueueConfiguration queue = FileJMSConfiguration.parseQueueConfiguration((Node)document.getDocumentElement());
                ActiveMQQueue activeMQQueue = ActiveMQDestination.createQueue((String)queue.getName());
                queueName = activeMQQueue.getAddress();
                ClientSession session = this.manager.getSessionFactory().createSession(false, false, false);
                try {
                    ClientSession.QueueQuery query = session.queueQuery(new SimpleString(queueName));
                    if (!query.isExists()) {
                        if (queue.getSelector() != null) {
                            session.createQueue(queueName, queueName, queue.getSelector(), queue.isDurable());
                        } else {
                            session.createQueue(queueName, queueName, queue.isDurable());
                        }
                        break block13;
                    }
                    throw new WebApplicationException(Response.status((int)412).type("text/plain").entity((Object)"Queue already exists.").build());
                }
                finally {
                    try {
                        session.close();
                    }
                    catch (Exception ignored) {}
                }
            }
            URI uri = uriInfo.getRequestUriBuilder().path(queueName).build(new Object[0]);
            return Response.created((URI)uri).build();
        }
        catch (Exception e) {
            if (e instanceof WebApplicationException) {
                throw (WebApplicationException)e;
            }
            throw new WebApplicationException((Throwable)e, Response.serverError().type("text/plain").entity((Object)"Failed to create queue.").build());
        }
    }

    public Map<String, QueueResource> getQueues() {
        return this.queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/{queue-name}")
    public synchronized QueueResource findQueue(@PathParam(value="queue-name") String name) throws Exception {
        QueueResource queue = this.queues.get(name);
        if (queue == null) {
            String queueName = name;
            ClientSession session = this.manager.getSessionFactory().createSession(false, false, false);
            try {
                ClientSession.QueueQuery query = session.queueQuery(new SimpleString(queueName));
                if (!query.isExists()) {
                    throw new WebApplicationException(Response.status((int)404).type("text/plain").entity((Object)("Queue '" + name + "' does not exist")).build());
                }
                DestinationSettings queueSettings = this.manager.getDefaultSettings();
                boolean defaultDurable = queueSettings.isDurableSend() || query.isDurable();
                queue = this.createQueueResource(queueName, defaultDurable, queueSettings.getConsumerSessionTimeoutSeconds(), queueSettings.isDuplicatesAllowed());
            }
            finally {
                try {
                    session.close();
                }
                catch (ActiveMQException e) {}
            }
        }
        return queue;
    }

    public QueueResource createQueueResource(String queueName, boolean defaultDurable, int timeoutSeconds, boolean duplicates) throws Exception {
        QueueResource queueResource = new QueueResource();
        queueResource.setQueueDestinationsResource(this);
        queueResource.setDestination(queueName);
        queueResource.setServiceManager(this.manager);
        ConsumersResource consumers = new ConsumersResource();
        consumers.setConsumerTimeoutSeconds(timeoutSeconds);
        consumers.setDestination(queueName);
        consumers.setSessionFactory(this.manager.getConsumerSessionFactory());
        consumers.setServiceManager(this.manager);
        queueResource.setConsumers(consumers);
        PushConsumerResource push = new PushConsumerResource();
        push.setDestination(queueName);
        push.setSessionFactory(this.manager.getConsumerSessionFactory());
        queueResource.setPushConsumers(push);
        PostMessage sender = null;
        sender = duplicates ? new PostMessageDupsOk() : new PostMessageNoDups();
        sender.setServiceManager(this.manager);
        sender.setDefaultDurable(defaultDurable);
        sender.setDestination(queueName);
        sender.setSessionFactory(this.manager.getSessionFactory());
        sender.setPoolSize(this.manager.getProducerPoolSize());
        sender.setProducerTimeToLive(this.manager.getProducerTimeToLive());
        sender.init();
        queueResource.setSender(sender);
        if (this.manager.getPushStore() != null) {
            push.setPushStore(this.manager.getPushStore());
            List<PushRegistration> regs = this.manager.getPushStore().getByDestination(queueName);
            for (PushRegistration reg : regs) {
                push.addRegistration(reg);
            }
        }
        queueResource.start();
        this.getQueues().put(queueName, queueResource);
        return queueResource;
    }
}

