/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.queue;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.rest.queue.DestinationSettings;
import org.apache.activemq.artemis.rest.util.LinkStrategy;
import org.apache.activemq.artemis.rest.util.TimeoutTask;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;

public abstract class DestinationServiceManager {
    protected ServerLocator locator;
    protected ClientSessionFactory sessionFactory;
    protected ServerLocator consumerServerLocator;
    protected ClientSessionFactory consumerSessionFactory;
    protected boolean started;
    protected String pushStoreFile;
    protected DestinationSettings defaultSettings = DestinationSettings.defaultSettings;
    protected TimeoutTask timeoutTask;
    protected int producerPoolSize;
    protected long producerTimeToLive;
    protected LinkStrategy linkStrategy;
    protected BindingRegistry registry;

    public BindingRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(BindingRegistry registry) {
        this.registry = registry;
    }

    public LinkStrategy getLinkStrategy() {
        return this.linkStrategy;
    }

    public void setLinkStrategy(LinkStrategy linkStrategy) {
        this.linkStrategy = linkStrategy;
    }

    public long getProducerTimeToLive() {
        return this.producerTimeToLive;
    }

    public void setProducerTimeToLive(long producerTimeToLive) {
        this.producerTimeToLive = producerTimeToLive;
    }

    public int getProducerPoolSize() {
        return this.producerPoolSize;
    }

    public void setProducerPoolSize(int producerPoolSize) {
        this.producerPoolSize = producerPoolSize;
    }

    public ClientSessionFactory getConsumerSessionFactory() {
        return this.consumerSessionFactory;
    }

    public void setConsumerSessionFactory(ClientSessionFactory consumerSessionFactory) {
        this.consumerSessionFactory = consumerSessionFactory;
    }

    public ServerLocator getConsumerServerLocator() {
        return this.consumerServerLocator;
    }

    public void setConsumerServerLocator(ServerLocator consumerServerLocator) {
        this.consumerServerLocator = consumerServerLocator;
    }

    public TimeoutTask getTimeoutTask() {
        return this.timeoutTask;
    }

    public void setTimeoutTask(TimeoutTask timeoutTask) {
        this.timeoutTask = timeoutTask;
    }

    public DestinationSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    public void setDefaultSettings(DestinationSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    public ServerLocator getServerLocator() {
        return this.locator;
    }

    public void setServerLocator(ServerLocator locator) {
        this.locator = locator;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getPushStoreFile() {
        return this.pushStoreFile;
    }

    public void setPushStoreFile(String pushStoreFile) {
        this.pushStoreFile = pushStoreFile;
    }

    protected void initDefaults() {
        if (this.locator == null) {
            this.locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName())});
        }
        if (this.sessionFactory == null) {
            try {
                this.sessionFactory = this.locator.createSessionFactory();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (this.consumerSessionFactory == null) {
            this.consumerSessionFactory = this.sessionFactory;
        }
        if (this.timeoutTask == null) {
            throw new RuntimeException("TimeoutTask is not set");
        }
    }

    public abstract void start() throws Exception;

    public abstract void stop();
}

