/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.integration;

import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.rest.MessageServiceManager;
import org.jboss.resteasy.plugins.server.tjws.TJWSEmbeddedJaxrsServer;
import org.jboss.resteasy.test.TestPortProvider;

public class EmbeddedRestActiveMQ {
    protected TJWSEmbeddedJaxrsServer tjws = new TJWSEmbeddedJaxrsServer();
    protected EmbeddedActiveMQ embeddedActiveMQ;
    protected MessageServiceManager manager = new MessageServiceManager();

    public EmbeddedRestActiveMQ() {
        int port = TestPortProvider.getPort();
        this.tjws.setPort(port);
        this.tjws.setRootResourcePath("");
        this.tjws.setSecurityDomain(null);
        this.initEmbeddedActiveMQ();
    }

    protected void initEmbeddedActiveMQ() {
        this.embeddedActiveMQ = new EmbeddedActiveMQ();
    }

    public TJWSEmbeddedJaxrsServer getTjws() {
        return this.tjws;
    }

    public void setTjws(TJWSEmbeddedJaxrsServer tjws) {
        this.tjws = tjws;
    }

    public EmbeddedActiveMQ getEmbeddedActiveMQ() {
        return this.embeddedActiveMQ;
    }

    public MessageServiceManager getManager() {
        return this.manager;
    }

    public void start() throws Exception {
        this.embeddedActiveMQ.start();
        this.tjws.start();
        this.manager.start();
        this.tjws.getDeployment().getRegistry().addSingletonResource((Object)this.manager.getQueueManager().getDestination());
        this.tjws.getDeployment().getRegistry().addSingletonResource((Object)this.manager.getTopicManager().getDestination());
    }

    public void stop() throws Exception {
        try {
            this.tjws.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.manager.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.embeddedActiveMQ.stop();
    }
}

