/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.management.impl.openmbean;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.reader.MapMessageUtil;
import org.apache.activemq.artemis.utils.TypedProperties;

public final class JMSOpenTypeSupport {
    private static final Map<Byte, AbstractOpenTypeFactory> OPEN_TYPE_FACTORIES = new HashMap<Byte, AbstractOpenTypeFactory>();

    private JMSOpenTypeSupport() {
    }

    public static OpenTypeFactory getFactory(Byte type) throws OpenDataException {
        return OPEN_TYPE_FACTORIES.get(type);
    }

    public static CompositeData convert(CompositeDataSupport data) throws OpenDataException {
        OpenTypeFactory f = JMSOpenTypeSupport.getFactory((Byte)data.get("type"));
        if (f == null) {
            throw new OpenDataException("Cannot create a CompositeData for type: " + data.get("type"));
        }
        CompositeType ct = f.getCompositeType();
        Map<String, Object> fields = f.getFields(data);
        return new CompositeDataSupport(ct, fields);
    }

    static {
        OPEN_TYPE_FACTORIES.put((byte)0, new MessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put((byte)3, new TextMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put((byte)4, new ByteMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put((byte)5, new MapMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put((byte)2, new ObjectMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put((byte)6, new StreamMessageOpenTypeFactory());
    }

    static class TextMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        TextMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return "TextMessage";
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("Text", "Text", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(CompositeDataSupport data) throws OpenDataException {
            Map<String, Object> rc = super.getFields(data);
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])((byte[])data.get("body")));
            SimpleString value = buffer.readNullableSimpleString();
            rc.put("Text", value != null ? value.toString() : "");
            return rc;
        }
    }

    static class StreamMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        StreamMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return "StreamMessage";
        }
    }

    static class ObjectMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        ObjectMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return "ObjectMessage";
        }
    }

    static class MapMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        MapMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return "MapMessage";
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("ContentMap", "Content map", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(CompositeDataSupport data) throws OpenDataException {
            Map<String, Object> rc = super.getFields(data);
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])((byte[])data.get("body")));
            TypedProperties properties = new TypedProperties();
            MapMessageUtil.readBodyMap((ActiveMQBuffer)buffer, (TypedProperties)properties);
            rc.put("ContentMap", "" + properties.getMap());
            return rc;
        }
    }

    static class ByteMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        ByteMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return "BytesMessage";
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("BodyLength", "Body length", SimpleType.LONG);
            this.addItem("BodyPreview", "Body preview", new ArrayType(SimpleType.BYTE, true));
        }

        @Override
        public Map<String, Object> getFields(CompositeDataSupport data) throws OpenDataException {
            Map<String, Object> rc = super.getFields(data);
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])((byte[])data.get("body")));
            long length = 0L;
            length = buffer.readableBytes();
            rc.put("BodyLength", length);
            byte[] preview = new byte[(int)Math.min(length, 255L)];
            buffer.readBytes(preview);
            rc.put("BodyPreview", preview);
            return rc;
        }
    }

    static class MessageOpenTypeFactory
    extends AbstractOpenTypeFactory {
        protected TabularType stringPropertyTabularType;
        protected TabularType booleanPropertyTabularType;
        protected TabularType bytePropertyTabularType;
        protected TabularType shortPropertyTabularType;
        protected TabularType intPropertyTabularType;
        protected TabularType longPropertyTabularType;
        protected TabularType floatPropertyTabularType;
        protected TabularType doublePropertyTabularType;
        protected ArrayType body;

        MessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return Message.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("JMSDestination", "The message destination", SimpleType.STRING);
            this.addItem("JMSMessageID", "The message ID", SimpleType.STRING);
            this.addItem("JMSCorrelationID", "The message correlation ID", SimpleType.STRING);
            this.addItem("JMSType", "The message type", SimpleType.STRING);
            this.addItem("JMSDeliveryMode", "The message delivery mode", SimpleType.STRING);
            this.addItem("JMSExpiration", "The message expiration", SimpleType.LONG);
            this.addItem("JMSPriority", "The message priority", SimpleType.INTEGER);
            this.addItem("JMSRedelivered", "Is the message redelivered", SimpleType.BOOLEAN);
            this.addItem("JMSTimestamp", "The message timestamp", SimpleType.DATE);
            this.addItem("JMSXGroupID", "The message group ID", SimpleType.STRING);
            this.addItem("JMSXGroupSeq", "The message group sequence number", SimpleType.INTEGER);
            this.addItem("JMSXUserID", "The user that sent the message", SimpleType.STRING);
            this.addItem("JMSReplyTo", "The reply to address", SimpleType.STRING);
            this.addItem("OriginalDestination", "Original Destination Before Senting To DLQ", SimpleType.STRING);
            this.addItem("PropertiesText", "The properties text", SimpleType.STRING);
            this.stringPropertyTabularType = this.createTabularType(String.class, SimpleType.STRING);
            this.booleanPropertyTabularType = this.createTabularType(Boolean.class, SimpleType.BOOLEAN);
            this.bytePropertyTabularType = this.createTabularType(Byte.class, SimpleType.BYTE);
            this.shortPropertyTabularType = this.createTabularType(Short.class, SimpleType.SHORT);
            this.intPropertyTabularType = this.createTabularType(Integer.class, SimpleType.INTEGER);
            this.longPropertyTabularType = this.createTabularType(Long.class, SimpleType.LONG);
            this.floatPropertyTabularType = this.createTabularType(Float.class, SimpleType.FLOAT);
            this.doublePropertyTabularType = this.createTabularType(Double.class, SimpleType.DOUBLE);
            this.addItem("StringProperties", "User String Properties", this.stringPropertyTabularType);
            this.addItem("BooleanProperties", "User Boolean Properties", this.booleanPropertyTabularType);
            this.addItem("ByteProperties", "User Byte Properties", this.bytePropertyTabularType);
            this.addItem("ShortProperties", "User Short Properties", this.shortPropertyTabularType);
            this.addItem("IntProperties", "User Int Properties", this.intPropertyTabularType);
            this.addItem("LongProperties", "User Long Properties", this.longPropertyTabularType);
            this.addItem("FloatProperties", "User Float Properties", this.floatPropertyTabularType);
            this.addItem("DoubleProperties", "User Double Properties", this.doublePropertyTabularType);
        }

        @Override
        public Map<String, Object> getFields(CompositeDataSupport data) throws OpenDataException {
            Map<String, Object> rc = super.getFields(data);
            this.putString(rc, data, "JMSMessageID", "userID");
            this.putString(rc, data, "JMSDestination", "address");
            this.putStringProperty(rc, data, "JMSReplyTo", "JMSReplyTo");
            rc.put("JMSType", this.getType());
            rc.put("JMSDeliveryMode", (Boolean)data.get("durable") != false ? "PERSISTENT" : "NON-PERSISTENT");
            rc.put("JMSExpiration", data.get("expiration"));
            rc.put("JMSTimestamp", new Date((Long)data.get("timestamp")));
            rc.put("JMSPriority", ((Byte)data.get("priority")).intValue());
            this.putStringProperty(rc, data, "JMSCorrelationID", "JMSCorrelationID");
            rc.put("JMSRedelivered", data.get("redelivered"));
            this.putStringProperty(rc, data, "JMSXGroupID", Message.HDR_GROUP_ID.toString());
            this.putIntProperty(rc, data, "JMSXGroupSeq", "JMSXGroupSeq");
            this.putStringProperty(rc, data, "JMSXUserID", "JMSXUserID");
            this.putStringProperty(rc, data, "OriginalDestination", Message.HDR_ORIGINAL_ADDRESS.toString());
            rc.put("PropertiesText", "" + data.get("PropertiesText"));
            rc.put("StringProperties", data.get("StringProperties"));
            rc.put("BooleanProperties", data.get("BooleanProperties"));
            rc.put("ByteProperties", data.get("ByteProperties"));
            rc.put("ShortProperties", data.get("ShortProperties"));
            rc.put("IntProperties", data.get("IntProperties"));
            rc.put("LongProperties", data.get("LongProperties"));
            rc.put("FloatProperties", data.get("FloatProperties"));
            rc.put("DoubleProperties", data.get("DoubleProperties"));
            return rc;
        }

        private void putString(Map<String, Object> rc, CompositeDataSupport data, String target, String source) {
            String prop = (String)data.get(source);
            if (prop != null) {
                rc.put(target, prop);
            } else {
                rc.put(target, "");
            }
        }

        private void putStringProperty(Map<String, Object> rc, CompositeDataSupport data, String target, String source) {
            TabularDataSupport properties = (TabularDataSupport)data.get("StringProperties");
            Object[] keys = new Object[]{source};
            CompositeDataSupport cds = (CompositeDataSupport)properties.get(keys);
            String prop = "";
            if (cds != null && cds.get("value") != null) {
                prop = (String)cds.get("value");
            }
            rc.put(target, prop);
        }

        private void putIntProperty(Map<String, Object> rc, CompositeDataSupport data, String target, String source) {
            TabularDataSupport properties = (TabularDataSupport)data.get("IntProperties");
            Object[] keys = new Object[]{source};
            CompositeDataSupport cds = (CompositeDataSupport)properties.get(keys);
            Integer prop = 0;
            if (cds != null && cds.get("value") != null) {
                prop = (Integer)cds.get("value");
            }
            rc.put(target, prop);
        }

        private String getType() {
            return "Message";
        }

        protected String toString(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        protected <T> TabularType createTabularType(Class<T> type, OpenType openType) throws OpenDataException {
            String typeName = "java.util.Map<java.lang.String, " + type.getName() + ">";
            String[] keyValue = new String[]{"key", "value"};
            OpenType[] openTypes = new OpenType[]{SimpleType.STRING, openType};
            CompositeType rowType = new CompositeType(typeName, typeName, keyValue, keyValue, openTypes);
            return new TabularType(typeName, typeName, rowType, new String[]{"key"});
        }
    }

    public static abstract class AbstractOpenTypeFactory
    implements OpenTypeFactory {
        private CompositeType compositeType;
        private final List<String> itemNamesList = new ArrayList<String>();
        private final List<String> itemDescriptionsList = new ArrayList<String>();
        private final List<OpenType> itemTypesList = new ArrayList<OpenType>();

        @Override
        public CompositeType getCompositeType() throws OpenDataException {
            if (this.compositeType == null) {
                this.init();
                this.compositeType = this.createCompositeType();
            }
            return this.compositeType;
        }

        protected void init() throws OpenDataException {
        }

        protected CompositeType createCompositeType() throws OpenDataException {
            String[] itemNames = this.itemNamesList.toArray(new String[this.itemNamesList.size()]);
            String[] itemDescriptions = this.itemDescriptionsList.toArray(new String[this.itemDescriptionsList.size()]);
            OpenType[] itemTypes = this.itemTypesList.toArray(new OpenType[this.itemTypesList.size()]);
            return new CompositeType(this.getTypeName(), this.getDescription(), itemNames, itemDescriptions, itemTypes);
        }

        protected abstract String getTypeName();

        protected void addItem(String name, String description, OpenType type) {
            this.itemNamesList.add(name);
            this.itemDescriptionsList.add(description);
            this.itemTypesList.add(type);
        }

        protected String getDescription() {
            return this.getTypeName();
        }

        @Override
        public Map<String, Object> getFields(CompositeDataSupport data) throws OpenDataException {
            HashMap<String, Object> rc = new HashMap<String, Object>();
            return rc;
        }
    }

    public static interface OpenTypeFactory {
        public CompositeType getCompositeType() throws OpenDataException;

        public Map<String, Object> getFields(CompositeDataSupport var1) throws OpenDataException;
    }
}

