/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.management.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.InvalidSelectorException;
import javax.management.MBeanInfo;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.FilterConstants;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.MessageCounterInfo;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.api.jms.management.JMSQueueControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.messagecounter.MessageCounter;
import org.apache.activemq.artemis.core.messagecounter.impl.MessageCounterHelper;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.management.impl.openmbean.JMSOpenTypeSupport;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.SelectorTranslator;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.json.JSONArray;
import org.apache.activemq.artemis.utils.json.JSONObject;

public class JMSQueueControlImpl
extends StandardMBean
implements JMSQueueControl {
    private final ActiveMQDestination managedQueue;
    private final JMSServerManager jmsServerManager;
    private final QueueControl coreQueueControl;
    private final MessageCounter counter;

    public static String createFilterFromJMSSelector(String selectorStr) throws ActiveMQException {
        return selectorStr == null || selectorStr.trim().length() == 0 ? null : SelectorTranslator.convertToActiveMQFilterString((String)selectorStr);
    }

    private static String createFilterForJMSMessageID(String jmsMessageID) throws Exception {
        return FilterConstants.ACTIVEMQ_USERID + " = '" + jmsMessageID + "'";
    }

    static String toJSON(Map<String, Object>[] messages) {
        JSONArray array = new JSONArray();
        for (Map<String, Object> message : messages) {
            array.put((Object)new JSONObject(message));
        }
        return array.toString();
    }

    public JMSQueueControlImpl(ActiveMQDestination managedQueue, QueueControl coreQueueControl, JMSServerManager jmsServerManager, MessageCounter counter) throws Exception {
        super(JMSQueueControl.class);
        this.managedQueue = managedQueue;
        this.jmsServerManager = jmsServerManager;
        this.coreQueueControl = coreQueueControl;
        this.counter = counter;
    }

    public String getName() {
        return this.managedQueue.getName();
    }

    public String getAddress() {
        return this.managedQueue.getAddress();
    }

    public boolean isTemporary() {
        return this.managedQueue.isTemporary();
    }

    public long getMessageCount() {
        return this.coreQueueControl.getMessageCount();
    }

    public long getMessagesAdded() {
        return this.coreQueueControl.getMessagesAdded();
    }

    public int getConsumerCount() {
        return this.coreQueueControl.getConsumerCount();
    }

    public int getDeliveringCount() {
        return this.coreQueueControl.getDeliveringCount();
    }

    public long getScheduledCount() {
        return this.coreQueueControl.getScheduledCount();
    }

    public boolean isDurable() {
        return this.coreQueueControl.isDurable();
    }

    public String getDeadLetterAddress() {
        return this.coreQueueControl.getDeadLetterAddress();
    }

    public String getExpiryAddress() {
        return this.coreQueueControl.getExpiryAddress();
    }

    public String getFirstMessageAsJSON() throws Exception {
        return this.coreQueueControl.getFirstMessageAsJSON();
    }

    public Long getFirstMessageTimestamp() throws Exception {
        return this.coreQueueControl.getFirstMessageTimestamp();
    }

    public Long getFirstMessageAge() throws Exception {
        return this.coreQueueControl.getFirstMessageAge();
    }

    public void addBinding(String binding) throws Exception {
        this.jmsServerManager.addQueueToBindingRegistry(this.managedQueue.getName(), binding);
    }

    public String[] getRegistryBindings() {
        return this.jmsServerManager.getBindingsOnQueue(this.managedQueue.getName());
    }

    public boolean removeMessage(String messageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int removed = this.coreQueueControl.removeMessages(filter);
        if (removed != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int removeMessages(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.removeMessages(filter);
    }

    public Map<String, Object>[] listMessages(String filterStr) throws Exception {
        try {
            String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
            Map[] coreMessages = this.coreQueueControl.listMessages(filter);
            return this.toJMSMap(coreMessages);
        }
        catch (ActiveMQException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private Map<String, Object>[] toJMSMap(Map<String, Object>[] coreMessages) {
        Map[] jmsMessages = new Map[coreMessages.length];
        int i = 0;
        for (Map<String, Object> coreMessage : coreMessages) {
            Map jmsMessage = ActiveMQMessage.coreMaptoJMSMap(coreMessage);
            jmsMessages[i++] = jmsMessage;
        }
        return jmsMessages;
    }

    private CompositeData toJMSCompositeType(CompositeDataSupport data) throws Exception {
        return JMSOpenTypeSupport.convert(data);
    }

    public Map<String, Object>[] listScheduledMessages() throws Exception {
        Map[] coreMessages = this.coreQueueControl.listScheduledMessages();
        return this.toJMSMap(coreMessages);
    }

    public String listScheduledMessagesAsJSON() throws Exception {
        return this.coreQueueControl.listScheduledMessagesAsJSON();
    }

    public Map<String, Map<String, Object>[]> listDeliveringMessages() throws Exception {
        try {
            HashMap<String, Map<String, Object>[]> returnMap = new HashMap<String, Map<String, Object>[]>();
            Map workingMap = this.coreQueueControl.listDeliveringMessages();
            for (Map.Entry entry : workingMap.entrySet()) {
                returnMap.put((String)entry.getKey(), this.toJMSMap((Map[])entry.getValue()));
            }
            return returnMap;
        }
        catch (ActiveMQException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String listDeliveringMessagesAsJSON() throws Exception {
        return this.coreQueueControl.listDeliveringMessagesAsJSON();
    }

    public String listMessagesAsJSON(String filter) throws Exception {
        return JMSQueueControlImpl.toJSON(this.listMessages(filter));
    }

    public long countMessages(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.countMessages(filter);
    }

    public boolean expireMessage(String messageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int expired = this.coreQueueControl.expireMessages(filter);
        if (expired != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int expireMessages(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.expireMessages(filter);
    }

    public boolean sendMessageToDeadLetterAddress(String messageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int dead = this.coreQueueControl.sendMessagesToDeadLetterAddress(filter);
        if (dead != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int sendMessagesToDeadLetterAddress(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.sendMessagesToDeadLetterAddress(filter);
    }

    public String sendTextMessageWithProperties(String properties) throws Exception {
        String[] kvs = properties.split(",");
        HashMap<String, String> props = new HashMap<String, String>();
        for (String kv : kvs) {
            String[] it = kv.split("=");
            if (it.length != 2) continue;
            props.put(it[0], it[1]);
        }
        return this.sendTextMessage(props, (String)props.remove("body"), (String)props.remove("username"), (String)props.remove("password"));
    }

    public String sendTextMessage(String body) throws Exception {
        return this.sendTextMessage(Collections.EMPTY_MAP, body);
    }

    public String sendTextMessage(Map<String, String> headers, String body) throws Exception {
        return this.sendTextMessage(headers, body, null, null);
    }

    public String sendTextMessage(String body, String user, String password) throws Exception {
        return this.sendTextMessage(Collections.EMPTY_MAP, body, user, password);
    }

    public String sendTextMessage(Map<String, String> headers, String body, String user, String password) throws Exception {
        String jmsDeliveryMode;
        boolean durable = false;
        if (headers.containsKey("JMSDeliveryMode") && (jmsDeliveryMode = headers.remove("JMSDeliveryMode")) != null && (jmsDeliveryMode.equals("2") || jmsDeliveryMode.equalsIgnoreCase("PERSISTENT"))) {
            durable = true;
        }
        String userID = UUIDGenerator.getInstance().generateStringUUID();
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)56);
        buffer.writeNullableSimpleString(new SimpleString(body));
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        this.coreQueueControl.sendMessage(headers, 3, Base64.encodeBytes((byte[])bytes), userID, durable, user, password);
        return userID;
    }

    public boolean changeMessagePriority(String messageID, int newPriority) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int changed = this.coreQueueControl.changeMessagesPriority(filter, newPriority);
        if (changed != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int changeMessagesPriority(String filterStr, int newPriority) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.changeMessagesPriority(filter, newPriority);
    }

    public boolean retryMessage(String jmsMessageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(jmsMessageID);
        Map[] messages = this.coreQueueControl.listMessages(filter);
        if (messages.length != 1) {
            return false;
        }
        Map messageToRedeliver = messages[0];
        Long messageID = (Long)messageToRedeliver.get("messageID");
        return messageID != null && this.coreQueueControl.retryMessage(messageID.longValue());
    }

    public int retryMessages() throws Exception {
        return this.coreQueueControl.retryMessages();
    }

    public boolean moveMessage(String messageID, String otherQueueName) throws Exception {
        return this.moveMessage(messageID, otherQueueName, false);
    }

    public boolean moveMessage(String messageID, String otherQueueName, boolean rejectDuplicates) throws Exception {
        ActiveMQQueue otherQueue;
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int moved = this.coreQueueControl.moveMessages(filter, (otherQueue = ActiveMQDestination.createQueue((String)otherQueueName)).getAddress(), rejectDuplicates);
        if (moved != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    public int moveMessages(String filterStr, String otherQueueName, boolean rejectDuplicates) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        ActiveMQQueue otherQueue = ActiveMQDestination.createQueue((String)otherQueueName);
        return this.coreQueueControl.moveMessages(filter, otherQueue.getAddress(), rejectDuplicates);
    }

    public int moveMessages(String filterStr, String otherQueueName) throws Exception {
        return this.moveMessages(filterStr, otherQueueName, false);
    }

    @Operation(desc="List all the existent consumers on the Queue")
    public String listConsumersAsJSON() throws Exception {
        return this.coreQueueControl.listConsumersAsJSON();
    }

    public String listMessageCounter() {
        try {
            return MessageCounterInfo.toJSon((MessageCounter)this.counter);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void resetMessageCounter() throws Exception {
        this.coreQueueControl.resetMessageCounter();
    }

    public String listMessageCounterAsHTML() {
        return MessageCounterHelper.listMessageCounterAsHTML((MessageCounter[])new MessageCounter[]{this.counter});
    }

    public String listMessageCounterHistory() throws Exception {
        return MessageCounterHelper.listMessageCounterHistory((MessageCounter)this.counter);
    }

    public String listMessageCounterHistoryAsHTML() {
        return MessageCounterHelper.listMessageCounterHistoryAsHTML((MessageCounter[])new MessageCounter[]{this.counter});
    }

    public boolean isPaused() throws Exception {
        return this.coreQueueControl.isPaused();
    }

    public void pause() throws Exception {
        this.coreQueueControl.pause();
    }

    public void resume() throws Exception {
        this.coreQueueControl.resume();
    }

    public CompositeData[] browse() throws Exception {
        return this.browse(null);
    }

    public CompositeData[] browse(String filter) throws Exception {
        try {
            CompositeData[] messages = this.coreQueueControl.browse(filter);
            ArrayList<CompositeData> c = new ArrayList<CompositeData>();
            for (CompositeData message : messages) {
                c.add(this.toJMSCompositeType((CompositeDataSupport)message));
            }
            CompositeData[] rc = new CompositeData[c.size()];
            c.toArray(rc);
            return rc;
        }
        catch (ActiveMQInvalidFilterExpressionException e) {
            throw new InvalidSelectorException(e.getMessage());
        }
    }

    public String getSelector() {
        return this.coreQueueControl.getFilter();
    }

    public void flushExecutor() {
        this.coreQueueControl.flushExecutor();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), MBeanInfoHelper.getMBeanAttributesInfo(JMSQueueControl.class), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(JMSQueueControl.class), info.getNotifications());
    }
}

