/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.handler.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.proton.plug.ClientSASL;
import org.proton.plug.SASLResult;
import org.proton.plug.ServerSASL;
import org.proton.plug.context.ProtonInitializable;
import org.proton.plug.handler.EventHandler;
import org.proton.plug.handler.Events;
import org.proton.plug.handler.ProtonHandler;

public class ProtonHandlerImpl
extends ProtonInitializable
implements ProtonHandler {
    private final Transport transport = Proton.transport();
    private final Connection connection = Proton.connection();
    private final Collector collector = Proton.collector();
    private final Executor dispatchExecutor;
    private final Runnable dispatchRunnable = new Runnable(){

        @Override
        public void run() {
            ProtonHandlerImpl.this.dispatch();
        }
    };
    private ArrayList<EventHandler> handlers = new ArrayList();
    private Sasl serverSasl;
    private Sasl clientSasl;
    private final Object lock = new Object();
    private final long creationTime;
    private Map<String, ServerSASL> saslHandlers;
    private SASLResult saslResult;
    protected volatile boolean dataReceived;
    protected boolean receivedFirstPacket = false;
    private int offset = 0;

    public ProtonHandlerImpl(Executor dispatchExecutor) {
        this.dispatchExecutor = dispatchExecutor;
        this.creationTime = System.currentTimeMillis();
        this.transport.bind(this.connection);
        this.connection.collect(this.collector);
    }

    @Override
    public long tick(boolean firstTick) {
        if (!firstTick) {
            try {
                if (this.connection.getLocalState() != EndpointState.CLOSED) {
                    long rescheduleAt = this.transport.tick(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
                    if (this.transport.isClosed()) {
                        throw new IllegalStateException("Channel was inactive for to long");
                    }
                    return rescheduleAt;
                }
            }
            catch (Exception e) {
                this.transport.close();
                this.connection.setCondition(new ErrorCondition());
            }
            return 0L;
        }
        return this.transport.tick(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int capacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.transport.capacity();
        }
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ProtonHandler addEventHandler(EventHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    @Override
    public void createServerSASL(ServerSASL[] handlers) {
        this.serverSasl = this.transport.sasl();
        this.saslHandlers = new HashMap<String, ServerSASL>();
        String[] names = new String[handlers.length];
        int count = 0;
        for (ServerSASL handler : handlers) {
            this.saslHandlers.put(handler.getName(), handler);
            names[count++] = handler.getName();
        }
        this.serverSasl.server();
        this.serverSasl.setMechanisms(names);
    }

    @Override
    public SASLResult getSASLResult() {
        return this.saslResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputBuffer(ByteBuf buffer) {
        this.dataReceived = true;
        Object object = this.lock;
        synchronized (object) {
            while (buffer.readableBytes() > 0) {
                int capacity = this.transport.capacity();
                if (!this.receivedFirstPacket) {
                    try {
                        if (buffer.getByte(4) == 3) {
                            this.dispatchSASL();
                            capacity = this.transport.capacity();
                        }
                    }
                    catch (Throwable ignored) {
                        ignored.printStackTrace();
                    }
                    this.receivedFirstPacket = true;
                }
                if (capacity > 0) {
                    ByteBuffer tail = this.transport.tail();
                    int min = Math.min(capacity, buffer.readableBytes());
                    tail.limit(min);
                    buffer.readBytes(tail);
                    this.flush();
                    continue;
                }
                if (capacity == 0) {
                    System.out.println("abandoning: " + buffer.readableBytes());
                    break;
                }
                System.out.println("transport closed, discarding: " + buffer.readableBytes() + " capacity = " + this.transport.capacity());
                break;
            }
        }
    }

    @Override
    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outputDone(int bytes) {
        Object object = this.lock;
        synchronized (object) {
            this.transport.pop(bytes);
            this.offset -= bytes;
            if (this.offset < 0) {
                throw new IllegalStateException("You called outputDone for more bytes than you actually received. numberOfBytes=" + bytes + ", outcome result=" + this.offset);
            }
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf outputBuffer() {
        Object object = this.lock;
        synchronized (object) {
            int pending = this.transport.pending();
            if (pending < 0) {
                return null;
            }
            int size = pending - this.offset;
            if (size < 0) {
                throw new IllegalStateException("negative size: " + pending);
            }
            if (size == 0) {
                return null;
            }
            ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer(size);
            ByteBuffer head = this.transport.head();
            head.position(this.offset);
            buffer.writeBytes(head);
            this.offset += size;
            return buffer;
        }
    }

    @Override
    public void createClientSasl(ClientSASL clientSASL) {
        if (clientSASL != null) {
            this.clientSasl = this.transport.sasl();
            this.clientSasl.setMechanisms(new String[]{clientSASL.getName()});
            byte[] initialSasl = clientSASL.getBytes();
            this.clientSasl.send(initialSasl, 0, initialSasl.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.transport.process();
            this.checkServerSASL();
        }
        this.dispatchExecutor.execute(this.dispatchRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.connection.close();
        }
        this.flush();
    }

    protected void checkServerSASL() {
        if (this.serverSasl != null && this.serverSasl.getRemoteMechanisms().length > 0) {
            ServerSASL mechanism = this.saslHandlers.get(this.serverSasl.getRemoteMechanisms()[0]);
            if (mechanism != null) {
                byte[] dataSASL = new byte[this.serverSasl.pending()];
                this.serverSasl.recv(dataSASL, 0, dataSASL.length);
                this.saslResult = mechanism.processSASL(dataSASL);
                if (this.saslResult != null && this.saslResult.isSuccess()) {
                    this.serverSasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                    this.serverSasl = null;
                    this.saslHandlers.clear();
                    this.saslHandlers = null;
                } else {
                    this.serverSasl.done(Sasl.SaslOutcome.PN_SASL_AUTH);
                }
                this.serverSasl = null;
            } else {
                this.serverSasl.done(Sasl.SaslOutcome.PN_SASL_SYS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event popEvent() {
        Object object = this.lock;
        synchronized (object) {
            Event ev = this.collector.peek();
            if (ev != null) {
                ev = ev.copy();
                this.collector.pop();
            }
            return ev;
        }
    }

    private void dispatchSASL() {
        for (EventHandler h : this.handlers) {
            h.onSASLInit(this, this.getConnection());
        }
    }

    private void dispatch() {
        Event ev;
        while ((ev = this.popEvent()) != null) {
            for (EventHandler h : this.handlers) {
                try {
                    Events.dispatch(ev, h);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.connection.setCondition(new ErrorCondition());
                }
            }
        }
        for (EventHandler h : this.handlers) {
            try {
                h.onTransport(this.transport);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.connection.setCondition(new ErrorCondition());
            }
        }
    }
}

